/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher;

import com.sk89q.mclauncher.InstallFromURLDialog;
import com.sk89q.mclauncher.Launcher;
import com.sk89q.mclauncher.config.Configuration;
import com.sk89q.mclauncher.config.ConfigurationList;
import com.sk89q.mclauncher.config.LauncherOptions;
import com.sk89q.mclauncher.model.UpdateManifest;
import com.sk89q.mclauncher.update.UpdateManifestFetcher;
import com.sk89q.mclauncher.util.LauncherUtils;
import com.sk89q.mclauncher.util.Task;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class InstallFromURLTask
extends Task {
    private final InstallFromURLDialog dialog;
    private final LauncherOptions options;
    private final String url;

    public InstallFromURLTask(InstallFromURLDialog dialog, LauncherOptions options, String url) {
        this.dialog = dialog;
        this.options = options;
        this.url = url;
    }

    @Override
    protected void execute() throws Task.ExecutionException {
        this.fireStatusChange("Downloading update manifest...");
        try {
            URL urlObject = new URL(this.url);
            UpdateManifestFetcher fetcher = new UpdateManifestFetcher(urlObject);
            fetcher.downloadManifest();
            final UpdateManifest manifest = fetcher.getManifest();
            if (!manifest.isValidForInstall()) {
                throw new Task.ExecutionException("The update manifest at the given URL has an invalid ID/name.");
            }
            String id = urlObject.getHost() + "_" + manifest.getId();
            Configuration existing = this.options.getConfigurations().get(id);
            if (existing != null) {
                throw new Task.ExecutionException("It looks like this pack is already installed as '" + existing.getName() + "'.");
            }
            LauncherUtils.checkInterrupted();
            Configuration configuration = Configuration.createInstance(id, manifest.getName(), urlObject);
            configuration.setLastLaunch(new Date());
            try {
                configuration.setNewsUrl(manifest.toNewsURL(urlObject));
                Launcher.getInstance().getOptions().save();
            }
            catch (MalformedURLException e) {
                throw new Task.ExecutionException("The manfiest at the URL has an invalid news URL.");
            }
            ConfigurationList configurations = this.options.getConfigurations();
            configurations.register(configuration);
            configurations.sortByDate();
            configurations.update(configuration);
            if (!this.options.save()) {
                throw new Task.ExecutionException("Your options could not be saved to disk.");
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(InstallFromURLTask.this.dialog, "The configuration '" + manifest.getName() + "' has been installed!", "Installed", 1);
                }
            });
            this.dialog.dispose();
        }
        catch (IOException e) {
            throw new Task.ExecutionException("Failed to install from the given URL: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new Task.ExecutionException("Unknown error", e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

