/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher;

import com.sk89q.mclauncher.Launcher;
import com.sk89q.mclauncher.LauncherFrame;
import com.sk89q.mclauncher.config.Configuration;
import com.sk89q.mclauncher.config.Identity;
import com.sk89q.mclauncher.config.IdentityList;
import com.sk89q.mclauncher.config.LauncherOptions;
import com.sk89q.mclauncher.config.MinecraftJar;
import com.sk89q.mclauncher.util.LinkButton;
import com.sk89q.mclauncher.util.PopupMouseAdapter;
import com.sk89q.mclauncher.util.SwingHelper;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class LaunchOptions
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = -4971412532761639415L;
    private final LauncherFrame frame;
    private final LauncherOptions options;
    private GridBagConstraints fieldC;
    private GridBagConstraints labelC;
    private GridBagConstraints checkboxC;
    private JComboBox jarCombo;
    private JComboBox userText;
    private JTextField passText;
    private JCheckBox rememberPass;
    private JCheckBox forceUpdateCheck;
    private JCheckBox changeComponentsCheck;
    private JCheckBox playOfflineCheck;
    private JCheckBox showConsoleCheck;
    private JCheckBox autoConnectCheck;
    private LinkButton expandBtn;
    private String autoConnect;
    private boolean demoMode;

    public LaunchOptions(LauncherFrame frame) {
        this.frame = frame;
        this.options = Launcher.getInstance().getOptions();
        this.createGridBagConstraints();
        this.addComponents();
        if (this.options.getSettings().getBool("launcher.always-more-options", false)) {
            this.expandBtn.doClick();
        }
    }

    private void createGridBagConstraints() {
        this.fieldC = new GridBagConstraints();
        this.fieldC.fill = 2;
        this.fieldC.weightx = 1.0;
        this.fieldC.gridwidth = 0;
        this.fieldC.insets = new Insets(2, 1, 2, 1);
        this.labelC = (GridBagConstraints)this.fieldC.clone();
        this.labelC.weightx = 0.0;
        this.labelC.gridwidth = 1;
        this.labelC.insets = new Insets(1, 1, 1, 10);
        this.checkboxC = (GridBagConstraints)this.fieldC.clone();
        this.checkboxC.insets = new Insets(5, 2, 1, 2);
    }

    private void addComponents() {
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        final JLabel jarLabel = new JLabel("Active JAR:", 2);
        JLabel userLabel = new JLabel("Username:", 2);
        JLabel passLabel = new JLabel("Password:", 2);
        this.jarCombo = new JComboBox();
        this.userText = new JComboBox();
        this.userText.setModel(this.options.getIdentities());
        this.userText.setEditable(true);
        this.passText = new JPasswordField(20);
        jarLabel.setLabelFor(this.jarCombo);
        userLabel.setLabelFor(this.userText);
        passLabel.setLabelFor(this.passText);
        layout.setConstraints(this.jarCombo, this.fieldC);
        layout.setConstraints(this.userText, this.fieldC);
        layout.setConstraints(this.passText, this.fieldC);
        this.rememberPass = new JCheckBox("Remember my password");
        this.rememberPass.setBorder(null);
        this.autoConnectCheck = new JCheckBox("Auto-connect");
        this.autoConnectCheck.setBorder(null);
        this.forceUpdateCheck = new JCheckBox("Force a game update");
        this.forceUpdateCheck.setBorder(null);
        this.changeComponentsCheck = new JCheckBox("Re-select install options (if any)");
        this.changeComponentsCheck.setBorder(null);
        this.playOfflineCheck = new JCheckBox("Play in offline mode");
        this.playOfflineCheck.setBorder(null);
        this.showConsoleCheck = new JCheckBox("Show messages and errors");
        this.showConsoleCheck.setBorder(null);
        this.expandBtn = new LinkButton("More options...");
        final JPanel expandContainer = new JPanel();
        expandContainer.setLayout(new BoxLayout(expandContainer, 0));
        expandContainer.setBorder(null);
        expandContainer.add(this.expandBtn);
        expandContainer.add(Box.createHorizontalGlue());
        this.add((Component)jarLabel, this.labelC);
        this.add((Component)this.jarCombo, this.fieldC);
        this.add((Component)userLabel, this.labelC);
        this.add((Component)this.userText, this.fieldC);
        this.add((Component)passLabel, this.labelC);
        this.add((Component)this.passText, this.fieldC);
        this.add((Component)this.rememberPass, this.checkboxC);
        this.add((Component)this.autoConnectCheck, this.checkboxC);
        this.add((Component)this.forceUpdateCheck, this.checkboxC);
        this.add((Component)this.changeComponentsCheck, this.checkboxC);
        this.add((Component)this.playOfflineCheck, this.checkboxC);
        this.add((Component)this.showConsoleCheck, this.checkboxC);
        this.add((Component)expandContainer, this.checkboxC);
        this.autoConnectCheck.setVisible(false);
        jarLabel.setVisible(false);
        this.jarCombo.setVisible(false);
        this.forceUpdateCheck.setVisible(false);
        this.changeComponentsCheck.setVisible(false);
        this.showConsoleCheck.setVisible(false);
        this.playOfflineCheck.setVisible(false);
        this.userText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LaunchOptions.this.loadSavedPassword();
            }
        });
        this.loadSavedPassword();
        this.userText.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    LaunchOptions.this.frame.launch();
                }
            }
        });
        this.userText.getEditor().getEditorComponent().addMouseListener(new PopupMouseAdapter(){

            @Override
            protected void showPopup(MouseEvent e) {
                LaunchOptions.this.popupIdentityMenu(e.getComponent(), e.getX(), e.getY());
            }
        });
        this.passText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    LaunchOptions.this.frame.launch();
                }
            }
        });
        this.playOfflineCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = ((JCheckBox)e.getSource()).isSelected();
                LaunchOptions.this.userText.setEnabled(!selected);
                LaunchOptions.this.passText.setEnabled(!selected);
                LaunchOptions.this.rememberPass.setEnabled(!selected);
            }
        });
        this.expandBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                expandContainer.setVisible(false);
                jarLabel.setVisible(true);
                LaunchOptions.this.jarCombo.setVisible(true);
                LaunchOptions.this.forceUpdateCheck.setVisible(true);
                LaunchOptions.this.changeComponentsCheck.setVisible(true);
                LaunchOptions.this.showConsoleCheck.setVisible(true);
                LaunchOptions.this.playOfflineCheck.setVisible(true);
            }
        });
    }

    private void popupIdentityMenu(Component component, int x, int y) {
        JMenuItem menuItem;
        final IdentityList identities = this.options.getIdentities();
        JPopupMenu popup = new JPopupMenu();
        final String username = this.getLoginId();
        if (identities.getPassword(username) != null) {
            menuItem = new JMenuItem("Forget '" + username + "' and its password");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    identities.forget(username);
                    LaunchOptions.this.options.save();
                }
            });
            popup.add(menuItem);
        }
        menuItem = new JMenuItem("Forget all saved passwords...");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JOptionPane.showConfirmDialog(LaunchOptions.this.frame, "Are you sure that you want to forget all saved passwords?", "Forget passwords", 0) == 0) {
                    identities.forgetAll();
                    LaunchOptions.this.options.save();
                }
            }
        });
        popup.add(menuItem);
        popup.show(component, x, y);
    }

    private void loadSavedPassword() {
        Identity selected = (Identity)this.userText.getSelectedItem();
        if (selected == null) {
            this.passText.setText("");
            this.rememberPass.setSelected(true);
            return;
        }
        Identity saved = this.options.getIdentities().byId(selected.getId());
        if (saved != null) {
            this.rememberPass.setSelected(saved.getPassword() != null);
            this.passText.setText(saved.getPassword());
        } else {
            this.rememberPass.setSelected(true);
        }
    }

    public Identity getIdentity() {
        if (!this.hasLoginSet()) {
            return null;
        }
        return new Identity(this.getLoginId(), this.getPassword());
    }

    public String getLoginId() {
        Object object = this.userText.getSelectedItem();
        if (object == null) {
            return null;
        }
        String name = String.valueOf(object).trim();
        return !name.isEmpty() ? name : null;
    }

    public String getPassword() {
        String password = this.passText.getText().trim();
        return !password.isEmpty() ? password : null;
    }

    public void setLogin(String username, String password) {
        ((JTextComponent)this.userText.getEditor().getEditorComponent()).setText(username);
        if (this.passText != null) {
            this.passText.setText(password);
        }
    }

    public boolean shouldRememberPassword() {
        return this.rememberPass.isSelected();
    }

    public MinecraftJar getActiveJar() {
        return (MinecraftJar)this.jarCombo.getSelectedItem();
    }

    public String getAutoConnect() {
        return this.autoConnect;
    }

    public String getEffectiveAutoConnect() {
        return this.autoConnect;
    }

    public void setAutoConnect(String address) {
        this.autoConnect = address;
        if (address == null) {
            this.autoConnectCheck.setSelected(false);
            this.autoConnectCheck.setVisible(false);
        } else {
            this.autoConnectCheck.setText("Auto-connect to '" + address + "'");
            this.autoConnectCheck.setSelected(true);
            this.autoConnectCheck.setVisible(true);
        }
    }

    public boolean getShowConsole() {
        return this.showConsoleCheck.isSelected();
    }

    public void setShowConsole(boolean show) {
        this.showConsoleCheck.setSelected(show);
    }

    public boolean isPlayingOffline() {
        return this.playOfflineCheck.isSelected();
    }

    public void setPlayOffline(boolean playOffline) {
        this.playOfflineCheck.setSelected(playOffline);
    }

    public boolean isForcingUpdate() {
        return this.forceUpdateCheck.isSelected();
    }

    public void setForceUpdate(boolean update) {
        this.forceUpdateCheck.setSelected(update);
    }

    public boolean isForcingIncrementalUpdate() {
        return this.changeComponentsCheck.isSelected();
    }

    public void setForceIncrementalUpdate(boolean update) {
        this.changeComponentsCheck.setSelected(update);
    }

    public boolean isUpdateRequested() {
        return this.isForcingUpdate() || this.isForcingIncrementalUpdate();
    }

    public boolean hasLoginSet() {
        return this.getLoginId() != null && this.getPassword() != null;
    }

    public void setTestMode() {
        this.setShowConsole(true);
        if (this.options.getSettings().getBool("addons.test.fast", false)) {
            this.setPlayOffline(true);
        }
    }

    public boolean isDemoMode() {
        return this.demoMode;
    }

    public void setDemoMode(boolean demoMode) {
        this.demoMode = demoMode;
    }

    public boolean verifyAndNotify() {
        if (!this.playOfflineCheck.isSelected() && this.getLoginId() == null) {
            SwingHelper.showError(this.frame, "No username", "A username must be entered.");
            return false;
        }
        if (!this.playOfflineCheck.isSelected() && this.getPassword() == null) {
            SwingHelper.showError(this.frame, "No password", "A password must be entered.");
            return false;
        }
        return true;
    }

    public void focusEmptyField() {
        if (this.getLoginId() == null) {
            this.userText.requestFocusInWindow();
        } else {
            this.passText.requestFocusInWindow();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Configuration configuration = (Configuration)((JList)e.getSource()).getSelectedValue();
        this.jarCombo.setModel(configuration.getJars());
    }
}

