/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher;

import com.sk89q.mclauncher.LaunchOptions;
import com.sk89q.mclauncher.Launcher;
import com.sk89q.mclauncher.config.Configuration;
import com.sk89q.mclauncher.config.Identity;
import com.sk89q.mclauncher.config.LauncherOptions;
import com.sk89q.mclauncher.config.MinecraftJar;
import com.sk89q.mclauncher.config.SettingsList;
import com.sk89q.mclauncher.event.ProgressListener;
import com.sk89q.mclauncher.launch.LaunchProcessBuilder;
import com.sk89q.mclauncher.session.LoginSession;
import com.sk89q.mclauncher.session.MinecraftSession;
import com.sk89q.mclauncher.session.OfflineSession;
import com.sk89q.mclauncher.update.UpdateCache;
import com.sk89q.mclauncher.update.UpdateCheck;
import com.sk89q.mclauncher.update.UpdateException;
import com.sk89q.mclauncher.update.Updater;
import com.sk89q.mclauncher.util.LauncherUtils;
import com.sk89q.mclauncher.util.SwingHelper;
import com.sk89q.mclauncher.util.Task;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLHandshakeException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class LaunchTask
extends Task {
    private final JFrame frame;
    private final MinecraftJar activeJar;
    private final Configuration configuration;
    private final LaunchOptions launchOptions;
    private final LauncherOptions options;
    private final Identity identity;
    private final File minecraftDir;
    private MinecraftSession session;

    public LaunchTask(JFrame frame, Configuration configuration, LaunchOptions launchOptions, MinecraftJar jar) {
        this.frame = frame;
        this.configuration = configuration;
        this.launchOptions = launchOptions;
        this.activeJar = jar;
        this.options = Launcher.getInstance().getOptions();
        this.identity = launchOptions.getIdentity();
        this.minecraftDir = configuration.getMinecraftDir();
    }

    @Override
    public void execute() throws Task.ExecutionException, InterruptedException {
        this.createSession();
        LauncherUtils.checkInterrupted();
        try {
            this.checkForUpdates();
        }
        catch (UpdateException e) {
            throw new Task.ExecutionException(e.getMessage(), e);
        }
        LauncherUtils.checkInterrupted();
        this.launch();
    }

    private void createSession() throws Task.ExecutionException, InterruptedException {
        if (this.launchOptions.isPlayingOffline()) {
            this.session = new OfflineSession();
            if (!Launcher.getInstance().getOptions().getIdentities().getHasLoggedIn()) {
                throw new Task.ExecutionException("Login once before using offline mode.");
            }
        } else {
            this.session = new LoginSession(this.identity.getId());
        }
        LauncherUtils.checkInterrupted();
        if (!this.session.isValid()) {
            this.login();
        }
    }

    private void login() throws Task.ExecutionException {
        block8: {
            this.fireTitleChange("Logging in...");
            this.fireStatusChange("Connecting to login server...");
            this.fireValueChange(-1.0);
            try {
                this.session.login(this.identity.getPassword());
                this.options.getIdentities().setHasLoggedIn(true);
                this.options.save();
            }
            catch (MinecraftSession.InvalidCredentialsException e) {
                throw new Task.ExecutionException("You've entered an invalid username/password combination.");
            }
            catch (MinecraftSession.OutdatedLauncherException e) {
                throw new Task.ExecutionException("It looks like this launcher needs to be updated.");
            }
            catch (MinecraftSession.UserNotPremiumException e) {
                if (!this.launchOptions.isDemoMode()) {
                    SwingHelper.showError(this.getComponent(), "Not Premium", "You aren't logging in to a premium account.\nMinecraft will run in demo mode.");
                }
                this.launchOptions.setDemoMode(true);
            }
            catch (MinecraftSession.LoginException e) {
                throw new Task.ExecutionException("A login error has occurred: " + e.getMessage());
            }
            catch (SSLHandshakeException e) {
                throw new Task.ExecutionException("Uh oh, couldn't confirm that the the login server connected to was owned by Mojang. You probably need to update your launcher.");
            }
            catch (IOException e) {
                String message = e instanceof UnknownHostException ? "host is unresolved: " + e.getMessage() : e.getMessage();
                if (!SwingHelper.confirm(this.getComponent(), "Login error", "The Minecraft login server is unreachable (" + message + "). " + "Would you like to play offline?")) break block8;
                this.launchOptions.setPlayOffline(true);
            }
        }
    }

    public void checkForUpdates() throws Task.ExecutionException, InterruptedException, UpdateException {
        Updater.UpdateType updateType;
        if (this.launchOptions.isPlayingOffline()) {
            return;
        }
        if (!this.activeJar.allowsUpdate()) {
            return;
        }
        this.fireStatusChange("Checking for updates...");
        File cacheFile = new File(this.minecraftDir, "update_cache.xml");
        UpdateCache cache = new UpdateCache(cacheFile);
        UpdateCheck updateCheck = this.configuration.createUpdateCheck(this.session, cache);
        if (!this.activeJar.isInstalled(this.minecraftDir)) {
            updateType = Updater.UpdateType.FULL;
        } else if (this.launchOptions.isForcingUpdate()) {
            updateType = Updater.UpdateType.FULL;
        } else if (this.launchOptions.isForcingIncrementalUpdate()) {
            updateType = Updater.UpdateType.INCREMENTAL;
        } else {
            block16: {
                try {
                    if (!updateCheck.needsUpdate()) {
                        return;
                    }
                }
                catch (InterruptedException e) {
                    throw new InterruptedException();
                }
                catch (UpdateException e) {
                    if (SwingHelper.confirm(this.getComponent(), "Update check failed", "The update server is unreachable (" + e.getMessage() + "). " + "Would you like to continue playing without checking for updates?")) break block16;
                    throw new InterruptedException();
                }
            }
            if (!SwingHelper.confirm(this.getComponent(), "Update available", "An update is available. Would you like to update?")) {
                return;
            }
            updateType = Updater.UpdateType.INCREMENTAL;
        }
        LauncherUtils.checkInterrupted();
        this.fireStatusChange("Creating updater...");
        Updater updater = updateCheck.createUpdater();
        updater.setOwner(this.frame);
        for (ProgressListener listener : this.getProgressListenerList()) {
            updater.addProgressListener(listener);
        }
        LauncherUtils.checkInterrupted();
        this.fireTitleChange("Updating '" + this.configuration.getName() + "'...");
        try {
            updater.update(updateType);
        }
        catch (UpdateException e) {
            throw new Task.ExecutionException(e.getMessage(), e);
        }
    }

    private void launch() throws Task.ExecutionException {
        this.fireTitleChange("Launching...");
        this.fireStatusChange("Launching Minecraft...");
        this.fireValueChange(-1.0);
        SettingsList settings = new SettingsList(Launcher.getInstance().getOptions().getSettings(), this.configuration.getSettings());
        LaunchProcessBuilder builder = new LaunchProcessBuilder(this.configuration, this.session);
        builder.readSettings(settings);
        builder.setShowConsole(builder.getShowConsole() || this.launchOptions.getShowConsole());
        builder.setActiveJar(this.activeJar.getName());
        builder.setDemo(this.launchOptions.isDemoMode());
        builder.setAutoConnect(this.launchOptions.getAutoConnect());
        try {
            builder.launch();
        }
        catch (IOException e) {
            throw new Task.ExecutionException(e.getMessage(), e.getCause());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LaunchTask.this.frame.dispose();
            }
        });
    }

    @Override
    public boolean tryCancel() {
        return JOptionPane.showConfirmDialog(this.getComponent(), "Are you sure you want to cancel?", "Cancel", 0) == 0;
    }

    public static enum UpdateRequirement {
        NEVER,
        CHECK_FOR_UPDATE,
        NEED_UPDATE;

    }
}

