/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher;

import com.sk89q.mclauncher.LauncherFrame;
import com.sk89q.mclauncher.config.Constants;
import com.sk89q.mclauncher.config.LauncherOptions;
import com.sk89q.mclauncher.security.X509KeyRing;
import com.sk89q.mclauncher.util.BasicArgsParser;
import com.sk89q.mclauncher.util.ConsoleFrame;
import com.sk89q.mclauncher.util.LauncherUtils;
import com.sk89q.mclauncher.util.Platform;
import com.sk89q.mclauncher.util.SimpleLogFormatter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.swing.SwingUtilities;

public class Launcher {
    private static final Logger logger;
    public static final String VERSION;
    private static String noticesText;
    private static volatile ConsoleFrame consoleFrame;
    private LauncherOptions options;
    private X509KeyRing keyRing;
    private static Launcher instance;

    public static Launcher getInstance() {
        return instance;
    }

    private Launcher() {
        instance = this;
        System.setProperty("http.agent", "SKMCLauncher/" + VERSION + " (+http://www.sk89q.com)");
        SimpleLogFormatter.setAsFormatter();
        File base = Launcher.getLauncherDataDir();
        base.mkdirs();
        File optionsFile = new File(base, "config.xml");
        this.options = new LauncherOptions(optionsFile);
        this.options.load();
        if (!optionsFile.exists()) {
            this.options.getIdentities().importLogins();
        }
        this.keyRing = new X509KeyRing();
        try {
            Constants.register(this.keyRing);
        }
        catch (CertificateException e) {
            logger.log(Level.SEVERE, "Failed to install register built-in certificates", e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to install register built-in certificates", e);
        }
    }

    public LauncherOptions getOptions() {
        return this.options;
    }

    public X509KeyRing getKeyRing() {
        return this.keyRing;
    }

    public Cipher getCipher(int mode, String password) throws InvalidKeySpecException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Random random = new Random(43287234L);
        byte[] salt = new byte[8];
        random.nextBytes(salt);
        PBEParameterSpec paramSpec = new PBEParameterSpec(salt, 5);
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
        SecretKey key = factory.generateSecret(new PBEKeySpec(password.toCharArray()));
        Cipher cipher = Cipher.getInstance("PBEWithMD5AndDES");
        cipher.init(mode, (Key)key, paramSpec);
        return cipher;
    }

    public static File getOfficialDataDir() {
        File dir = Launcher.getAppDataDir("minecraft");
        return dir;
    }

    public static File toMinecraftDir(File base) {
        switch (Launcher.getPlatform()) {
            case LINUX: 
            case SOLARIS: {
                return new File(base, ".minecraft");
            }
            case WINDOWS: {
                return new File(base, ".minecraft");
            }
            case MAC_OS_X: {
                return new File(base, "Library/Application Support/minecraft");
            }
        }
        return new File(base, "minecraft");
    }

    public static File getAppDataDir() {
        File workingDir;
        String homeDir = System.getProperty("user.home", ".");
        switch (Launcher.getPlatform()) {
            case LINUX: 
            case SOLARIS: {
                workingDir = new File(homeDir);
                break;
            }
            case WINDOWS: {
                String applicationData = System.getenv("APPDATA");
                if (applicationData != null) {
                    workingDir = new File(applicationData);
                    break;
                }
                workingDir = new File(homeDir);
                break;
            }
            case MAC_OS_X: {
                workingDir = new File(homeDir);
                break;
            }
            default: {
                workingDir = new File(homeDir);
            }
        }
        return workingDir;
    }

    public static File getAppDataDir(String appDir) {
        File workingDir;
        String homeDir = System.getProperty("user.home", ".");
        switch (Launcher.getPlatform()) {
            case LINUX: 
            case SOLARIS: {
                workingDir = new File(homeDir, "." + appDir + "/");
                break;
            }
            case WINDOWS: {
                String applicationData = System.getenv("APPDATA");
                if (applicationData != null) {
                    workingDir = new File(applicationData, "." + appDir + "/");
                    break;
                }
                workingDir = new File(homeDir, "." + appDir + "/");
                break;
            }
            case MAC_OS_X: {
                workingDir = new File(homeDir, "Library/Application Support/" + appDir);
                break;
            }
            default: {
                workingDir = new File(homeDir, appDir + "/");
            }
        }
        return workingDir;
    }

    public static File getLauncherDataDir() {
        String homeDir = System.getProperty("user.home", ".");
        File workingDir = new File(".", "config.xml");
        if (workingDir.exists()) {
            return new File(".");
        }
        switch (Launcher.getPlatform()) {
            case LINUX: 
            case SOLARIS: {
                workingDir = new File(homeDir, ".skmclauncher");
                break;
            }
            case WINDOWS: {
                String applicationData = System.getenv("APPDATA");
                if (applicationData != null) {
                    workingDir = new File(applicationData, "SKMCLauncher");
                    break;
                }
                workingDir = new File(homeDir, "SKMCLauncher");
                break;
            }
            case MAC_OS_X: {
                workingDir = new File(homeDir, "Library/Application Support/SKMCLauncher");
                break;
            }
            default: {
                workingDir = new File(homeDir, "SKMCLauncher");
            }
        }
        if (!new File(workingDir, "config.xml").exists()) {
            workingDir = Launcher.getOfficialDataDir();
        }
        if (!workingDir.exists() && !workingDir.mkdirs()) {
            throw new RuntimeException("Unable to create " + workingDir);
        }
        return workingDir;
    }

    public static File getInstanceDataDir() {
        return new File(Launcher.getLauncherDataDir(), "instances");
    }

    public static File replacePathTokens(String path) {
        return new File(path.replace("%INSTANCEDIR%", Launcher.getInstanceDataDir().getAbsolutePath() + File.separator));
    }

    public static void showConsole() {
        final boolean colorEnabled = Launcher.getInstance().getOptions().getSettings().getBool("console.colored", true);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ConsoleFrame frame = consoleFrame;
                    if (frame == null || !frame.isRunning()) {
                        frame = new ConsoleFrame(10000, colorEnabled);
                        consoleFrame = frame;
                        frame.setTitle("Launcher Debugging Console");
                        frame.getMessageLog().registerLoggerHandler();
                        frame.setVisible(true);
                    } else {
                        frame.setVisible(true);
                        frame.requestFocus();
                    }
                }
            });
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public static Platform getPlatform() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return Platform.WINDOWS;
        }
        if (osName.contains("mac")) {
            return Platform.MAC_OS_X;
        }
        if (osName.contains("solaris") || osName.contains("sunos")) {
            return Platform.SOLARIS;
        }
        if (osName.contains("linux")) {
            return Platform.LINUX;
        }
        if (osName.contains("unix")) {
            return Platform.LINUX;
        }
        return Platform.UNKNOWN;
    }

    public static String getNotices() {
        if (noticesText != null) {
            return noticesText;
        }
        BufferedReader in = null;
        try {
            InputStream f = Launcher.class.getResourceAsStream("/resources/NOTICE.txt");
            if (f == null) {
                logger.log(Level.WARNING, "Failed to read NOTICE.txt");
                LauncherUtils.close(in);
                noticesText = "<Failed to read NOTICE.txt>";
                return "<Failed to read NOTICE.txt>";
            }
            in = new BufferedReader(new InputStreamReader(f));
            StringBuilder contents = new StringBuilder();
            char[] buffer = new char[4096];
            int read = 0;
            do {
                contents.append(buffer, 0, read);
            } while ((read = in.read(buffer)) >= 0);
            noticesText = contents.toString();
            return noticesText;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to read NOTICE.txt", e);
            LauncherUtils.close(in);
            noticesText = "<Failed to read NOTICE.txt>";
            return "<Failed to read NOTICE.txt>";
        }
    }

    public static void main(String[] args) {
        BasicArgsParser parser = new BasicArgsParser();
        parser.addValueArg("address");
        parser.addValueArg("username");
        parser.addValueArg("password");
        parser.addFlagArg("launch");
        BasicArgsParser.ArgsContext context = parser.parse(args);
        final String autoConnect = context.get("address");
        final String username = context.get("username");
        final String password = context.get("password");
        final boolean autoLaunch = context.has("launch");
        new Launcher();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LauncherFrame frame = new LauncherFrame();
                frame.setVisible(true);
                if (username != null) {
                    frame.getLaunchSettings().setLogin(username, password);
                }
                if (autoConnect != null && autoConnect.matches("^[A-Za-z0-9\\.]{1,128}(?::[0-9]+)?$")) {
                    frame.getLaunchSettings().setAutoConnect(autoConnect);
                }
                if (autoLaunch) {
                    frame.launch();
                }
            }
        });
    }

    public static void startLauncherFrame() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LauncherFrame frame = new LauncherFrame();
                frame.setVisible(true);
            }
        });
    }

    static {
        String v;
        logger = Logger.getLogger(Launcher.class.getCanonicalName());
        Package p = Launcher.class.getPackage();
        if (p == null) {
            p = Package.getPackage("com.sk89q.mclauncher");
        }
        VERSION = p == null ? "(unknown)" : ((v = p.getImplementationVersion()) == null ? "(unknown)" : v);
    }
}

