/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher;

import com.sk89q.mclauncher.ClassicView;
import com.sk89q.mclauncher.LaunchOptions;
import com.sk89q.mclauncher.LaunchTask;
import com.sk89q.mclauncher.Launcher;
import com.sk89q.mclauncher.LauncherView;
import com.sk89q.mclauncher.config.Configuration;
import com.sk89q.mclauncher.config.Identity;
import com.sk89q.mclauncher.config.IdentityList;
import com.sk89q.mclauncher.config.LauncherOptions;
import com.sk89q.mclauncher.config.MinecraftJar;
import com.sk89q.mclauncher.util.SwingHelper;
import com.sk89q.mclauncher.util.Task;
import com.sk89q.mclauncher.util.TaskWorker;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class LauncherFrame
extends JFrame {
    private static final long serialVersionUID = 4122023031876609883L;
    private final LauncherOptions options;
    private final LaunchOptions launchOptions;
    private LauncherView view;
    private TaskWorker worker = new TaskWorker();

    public LauncherFrame() {
        this.setTitle("SK's Minecraft Launcher");
        this.setSize(620, 500);
        SwingHelper.setLookAndFeel();
        SwingHelper.setIconImage(this, "/resources/icon.png");
        this.options = Launcher.getInstance().getOptions();
        this.launchOptions = new LaunchOptions(this);
        this.view = new ClassicView(this, this.launchOptions);
        this.add((Component)this.view, "Center");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                LauncherFrame.this.view.cleanUp();
                LauncherFrame.this.dispose();
            }
        });
        this.setLocationRelativeTo(null);
    }

    public Configuration getSelected() {
        return this.view.getSelected();
    }

    public LaunchOptions getLaunchSettings() {
        return this.launchOptions;
    }

    public void launch() {
        if (this.worker.isAlive()) {
            return;
        }
        Configuration configuration = this.getSelected();
        IdentityList identities = this.options.getIdentities();
        if (!this.launchOptions.verifyAndNotify()) {
            return;
        }
        Identity identity = this.launchOptions.getIdentity();
        boolean remember = this.launchOptions.shouldRememberPassword();
        MinecraftJar jar = this.launchOptions.getActiveJar();
        if (!this.launchOptions.isPlayingOffline()) {
            if (remember) {
                identities.remember(identity.getId(), identity.getPassword());
            } else {
                identities.forgetPassword(identity.getId());
            }
        } else {
            identity = new Identity("Player", null);
        }
        configuration.updateLastLaunch();
        configuration.setLastJar(jar);
        this.options.getConfigurations().sortByDate();
        this.view.selectAfterSort();
        this.options.save();
        LaunchTask task = new LaunchTask(this, configuration, this.launchOptions, jar);
        this.worker = Task.startWorker(this, task);
    }
}

