/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher;

import com.sk89q.mclauncher.ConfigurationDialog;
import com.sk89q.mclauncher.EnvironmentOptionsPanel;
import com.sk89q.mclauncher.Launcher;
import com.sk89q.mclauncher.LauncherFrame;
import com.sk89q.mclauncher.LauncherOptionsPanel;
import com.sk89q.mclauncher.OptionsPanel;
import com.sk89q.mclauncher.config.Configuration;
import com.sk89q.mclauncher.config.ConfigurationList;
import com.sk89q.mclauncher.config.LauncherOptions;
import com.sk89q.mclauncher.util.ActionListeners;
import com.sk89q.mclauncher.util.ButtonsPanel;
import com.sk89q.mclauncher.util.LinkButton;
import com.sk89q.mclauncher.util.SwingHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultCaret;

public class OptionsDialog
extends JDialog {
    private static final long serialVersionUID = -1889866989693082182L;
    private LauncherOptions options;
    private JTable configsTable;
    private JTabbedPane tabs;
    private List<OptionsPanel> optionsPanels = new ArrayList<OptionsPanel>();

    public OptionsDialog(LauncherFrame owner, Configuration configuration, LauncherOptions options, int initialTab) {
        super(owner, "Launcher Options", true);
        this.options = options;
        this.setResizable(true);
        this.buildUI();
        this.pack();
        this.setSize(400, 540);
        this.setLocationRelativeTo(owner);
        this.tabs.setSelectedIndex(initialTab);
        for (OptionsPanel panel : this.optionsPanels) {
            panel.copySettingsToFields();
        }
    }

    boolean save(boolean copySettings) {
        if (copySettings) {
            for (OptionsPanel panel : this.optionsPanels) {
                panel.copyFieldsToSettings();
            }
        }
        if (!this.options.save()) {
            JOptionPane.showMessageDialog(this, "Your options could not be saved to disk.", "Save error", 0);
            return false;
        }
        return true;
    }

    private <T extends OptionsPanel> T wrap(T panel) {
        this.optionsPanels.add(panel);
        return panel;
    }

    private void buildUI() {
        final OptionsDialog self = this;
        JPanel container = new JPanel();
        container.setBorder(BorderFactory.createEmptyBorder(8, 8, 5, 8));
        container.setLayout(new BorderLayout(3, 3));
        this.tabs = new JTabbedPane();
        this.tabs.addTab("Launcher", this.wrap(new LauncherOptionsPanel(this.options.getSettings(), false)));
        this.tabs.addTab("Environment", this.wrap(new EnvironmentOptionsPanel(this.options.getSettings(), false)));
        this.tabs.addTab("Configurations", this.buildConfigurationsPanel());
        container.add((Component)this.tabs, "Center");
        ButtonsPanel buttons = new ButtonsPanel(8, 0, 6, 0);
        buttons.button("About...", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(self, OptionsDialog.this.buildAboutPanel(), "About the Launcher", -1);
            }
        });
        buttons.gap();
        JButton okButton = buttons.addButton("OK");
        buttons.spacer();
        JButton cancelButton = buttons.addButton("Cancel");
        SwingHelper.equalWidth(okButton, cancelButton);
        container.add((Component)buttons, "South");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OptionsDialog.this.save(true)) {
                    self.dispose();
                }
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                self.dispose();
            }
        });
        this.add((Component)container, "Center");
    }

    private JPanel buildConfigurationsPanel() {
        final OptionsDialog self = this;
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        JButton newBtn = new JButton("New...");
        buttonsPanel.add(newBtn);
        buttonsPanel.add(Box.createHorizontalStrut(3));
        JButton modifyBtn = new JButton("Modify...");
        buttonsPanel.add(modifyBtn);
        buttonsPanel.add(Box.createHorizontalGlue());
        JButton removeBtn = new JButton("Delete...");
        buttonsPanel.add(removeBtn);
        panel.add(buttonsPanel);
        panel.add(Box.createVerticalStrut(3));
        this.configsTable = new JTable();
        this.configsTable.setShowGrid(false);
        this.configsTable.setRowHeight(this.configsTable.getRowHeight() + 2);
        this.configsTable.setIntercellSpacing(new Dimension(0, 0));
        this.configsTable.setFillsViewportHeight(true);
        this.configsTable.setSelectionMode(2);
        this.configsTable.setModel(this.options.getConfigurations());
        this.configsTable.getColumnModel().getColumn(0).setPreferredWidth(30);
        JScrollPane tableScroll = new JScrollPane(this.configsTable);
        panel.add((Component)tableScroll, "Center");
        newBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ConfigurationDialog((Window)self).setVisible(true);
            }
        });
        modifyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int min = OptionsDialog.this.configsTable.getSelectionModel().getMinSelectionIndex();
                int max = OptionsDialog.this.configsTable.getSelectionModel().getMaxSelectionIndex();
                if (min == -1 || max == -1) {
                    SwingHelper.showError(self, "Selection error", "You have not selected any configurations.");
                    return;
                }
                if (min != max) {
                    SwingHelper.showError(self, "Selection error", "Select one configuration at a time.");
                    return;
                }
                Configuration config = OptionsDialog.this.options.getConfigurations().getConfigurationAt(min);
                new ConfigurationDialog((Window)self, config).setVisible(true);
            }
        });
        removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int min = OptionsDialog.this.configsTable.getSelectionModel().getMinSelectionIndex();
                int max = OptionsDialog.this.configsTable.getSelectionModel().getMaxSelectionIndex();
                if (min == -1 || max == -1) {
                    SwingHelper.showError(self, "Selection error", "You have not selected any configurations.");
                    return;
                }
                if (JOptionPane.showConfirmDialog(self, "Are you sure you want to remove the selected configuration? No files will be deleted.", "Remove", 0) != 0) {
                    return;
                }
                ConfigurationList configsManager = OptionsDialog.this.options.getConfigurations();
                for (int i = min; i <= max; ++i) {
                    Configuration config = configsManager.getConfigurationAt(i);
                    if (config.isBuiltIn()) {
                        SwingHelper.showError(self, "Built-in configuration", "The configuration '" + config.getName() + "' is built-in and cannot be removed.");
                        continue;
                    }
                    configsManager.remove(config);
                }
                OptionsDialog.this.save(false);
            }
        });
        SwingHelper.removeOpaqueness(buttonsPanel);
        return panel;
    }

    private JPanel buildAboutPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        panel.setLayout(new BoxLayout(panel, 1));
        JLabel label = new JLabel("SK's Minecraft Launcher");
        label.setAlignmentX(0.0f);
        panel.add(label);
        label = new JLabel("Version " + Launcher.VERSION);
        label.setAlignmentX(0.0f);
        panel.add(label);
        LinkButton btn = new LinkButton("https://github.com/sk89q/skmclauncher");
        btn.setAlignmentX(0.0f);
        panel.add(btn);
        panel.add(Box.createVerticalStrut(20));
        final JTextArea text = new JTextArea(){
            private static final long serialVersionUID = -1743545646109139950L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(300, super.getPreferredSize().height);
            }
        };
        text.setEditable(false);
        text.setWrapStyleWord(true);
        text.setLineWrap(true);
        text.setFont(label.getFont());
        DefaultCaret caret = (DefaultCaret)text.getCaret();
        caret.setUpdatePolicy(1);
        JScrollPane scroll = new JScrollPane(text);
        scroll.setVerticalScrollBarPolicy(22);
        scroll.setHorizontalScrollBarPolicy(30);
        scroll.setAlignmentX(0.0f);
        scroll.setPreferredSize(new Dimension(text.getPreferredSize().width, 200));
        panel.add(scroll);
        panel.add(Box.createVerticalGlue());
        btn.addActionListener(ActionListeners.openURL(this, "https://github.com/sk89q/skmclauncher"));
        new Thread(new Runnable(){

            @Override
            public void run() {
                final String notices = Launcher.getNotices();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        text.setText(notices);
                    }
                });
            }
        }).start();
        return panel;
    }
}

