/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher;

import com.sk89q.mclauncher.config.SettingsList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class OptionsPanel
extends JPanel {
    private static final long serialVersionUID = 2156199128379585102L;
    protected GridBagConstraints fieldConstraints;
    protected GridBagConstraints labelConstraints;
    protected SettingsList settings;
    private List<SettingField<?>> fields = new ArrayList();
    private JPanel groupPanel;
    protected boolean withUse;

    public OptionsPanel(SettingsList settings, boolean withUse) {
        this.settings = settings;
        this.withUse = withUse;
        this.fieldConstraints = new GridBagConstraints();
        this.fieldConstraints.fill = 2;
        this.fieldConstraints.weightx = 1.0;
        this.fieldConstraints.gridwidth = 0;
        this.fieldConstraints.insets = new Insets(2, 5, 2, 5);
        this.labelConstraints = (GridBagConstraints)this.fieldConstraints.clone();
        this.labelConstraints.weightx = 0.0;
        this.labelConstraints.gridwidth = 1;
        this.labelConstraints.insets = new Insets(1, 5, 1, 10);
        this.buildUI();
        this.copySettingsToFields();
    }

    private void buildUI() {
        this.setLayout(new BoxLayout(this, 1));
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.buildControls();
        this.add(new Box.Filler(new Dimension(0, 0), new Dimension(0, 10000), new Dimension(0, 10000)));
    }

    private void popupFieldMenu(Component component, int x, int y, final SettingField<?> field) {
        if (this.settings.getParents() == null) {
            return;
        }
        JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Reset to default");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsPanel.this.copySettingToField(field, new SettingsList(OptionsPanel.this.settings.getParents()));
            }
        });
        popup.add(menuItem);
        popup.show(component, x, y);
    }

    protected abstract void buildControls();

    public void copySettingsToFields() {
        for (SettingField<?> field : this.fields) {
            if (this.withUse) {
                boolean isSet = this.settings.has(((SettingField)field).settingName);
                ((SettingField)field).useCheck.setSelected(isSet);
                ((SettingField)field).component.setEnabled(isSet);
                if (!isSet) continue;
            }
            this.copySettingToField(field, this.settings);
        }
    }

    private void copySettingToField(SettingField<?> field, SettingsList settings) {
        if (((SettingField)field).component instanceof JSpinner && ((JSpinner)((SettingField)field).component).getModel() instanceof SpinnerNumberModel) {
            ((JSpinner)((SettingField)field).component).setValue(settings.getInt(((SettingField)field).settingName, 0));
        } else if (((SettingField)field).component instanceof JCheckBox) {
            ((JCheckBox)((SettingField)field).component).setSelected(settings.getBool(((SettingField)field).settingName, false));
        } else if (((SettingField)field).component instanceof JTextField) {
            ((JTextField)((SettingField)field).component).setText(settings.get(((SettingField)field).settingName, ""));
        } else {
            throw new IllegalArgumentException("Don't know what to do with a " + ((SettingField)field).component.getClass().getCanonicalName());
        }
    }

    public void copyFieldsToSettings() {
        for (SettingField<?> field : this.fields) {
            if (this.withUse && !((SettingField)field).useCheck.isSelected()) {
                this.settings.unset(((SettingField)field).settingName);
                continue;
            }
            if (((SettingField)field).component instanceof JSpinner && ((JSpinner)((SettingField)field).component).getModel() instanceof SpinnerNumberModel) {
                this.settings.set(((SettingField)field).settingName, ((JSpinner)((SettingField)field).component).getValue());
                continue;
            }
            if (((SettingField)field).component instanceof JCheckBox) {
                this.settings.set(((SettingField)field).settingName, ((JCheckBox)((SettingField)field).component).isSelected());
                continue;
            }
            if (((SettingField)field).component instanceof JTextField) {
                this.settings.set(((SettingField)field).settingName, ((JTextField)((SettingField)field).component).getText());
                continue;
            }
            throw new IllegalArgumentException("Don't know what to do with a " + ((SettingField)field).component.getClass().getCanonicalName());
        }
    }

    protected JPanel createFieldGroup(String title) {
        OptionsPanel parent = this;
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createTitledBorder(title));
        panel.setLayout(new GridBagLayout());
        parent.add(panel);
        this.groupPanel = panel;
        return panel;
    }

    protected <T extends Component> T addField(String settingName, String label, T component) {
        JPanel parent = this.groupPanel;
        GridBagLayout layout = (GridBagLayout)parent.getLayout();
        JCheckBox useCheck = null;
        if (this.withUse) {
            useCheck = this.buildSetCheck(component);
            useCheck.setBorder(null);
            layout.setConstraints(useCheck, this.labelConstraints);
            parent.add(useCheck);
        }
        JLabel labelObj = new JLabel(label);
        layout.setConstraints(labelObj, this.labelConstraints);
        layout.setConstraints(component, this.fieldConstraints);
        labelObj.setLabelFor(component);
        parent.add(labelObj);
        parent.add(component);
        final SettingField field = new SettingField(this, settingName, component, useCheck);
        this.fields.add(field);
        if (!this.withUse) {
            component.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.maybeShowPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.maybeShowPopup(e);
                }

                private void maybeShowPopup(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        OptionsPanel.this.popupFieldMenu(e.getComponent(), e.getX(), e.getY(), field);
                    }
                }
            });
        }
        return component;
    }

    protected <T extends Component> T addField(String settingName, T component) {
        JPanel parent = this.groupPanel;
        if (component instanceof JComponent) {
            ((JComponent)component).setOpaque(false);
        }
        if (component instanceof JCheckBox) {
            ((JCheckBox)component).setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        }
        GridBagLayout layout = (GridBagLayout)parent.getLayout();
        JCheckBox useCheck = null;
        if (this.withUse) {
            useCheck = this.buildSetCheck(component);
            layout.setConstraints(useCheck, this.labelConstraints);
            parent.add(useCheck);
        }
        layout.setConstraints(component, this.fieldConstraints);
        parent.add(component);
        this.fields.add(new SettingField(this, settingName, component, useCheck));
        return component;
    }

    private JCheckBox buildSetCheck(final Component component) {
        final JCheckBox check = new JCheckBox("Set:");
        check.setBorder(null);
        check.setOpaque(false);
        check.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                component.setEnabled(check.isSelected());
            }
        });
        return check;
    }

    private static class SettingField<T extends Component> {
        private String settingName;
        private T component;
        private JCheckBox useCheck;
        final /* synthetic */ OptionsPanel this$0;

        public SettingField(String settingName, T component, JCheckBox useCheck) {
            this.this$0 = var1_1;
            this.settingName = settingName;
            this.component = component;
            this.useCheck = useCheck;
        }
    }
}

