/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher;

import com.sk89q.mclauncher.event.ProgressListener;
import com.sk89q.mclauncher.event.StatusChangeEvent;
import com.sk89q.mclauncher.event.TitleChangeEvent;
import com.sk89q.mclauncher.event.ValueChangeEvent;
import com.sk89q.mclauncher.util.Task;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ProgressDialog
extends JDialog
implements ProgressListener {
    private static final long serialVersionUID = 7258236630228982935L;
    private JProgressBar progressBar;
    private JLabel statusLabel;
    private Task task;
    private JButton cancelButton;

    public ProgressDialog(Window owner, Task task, String title) {
        super(owner, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.task = task;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                ProgressDialog.this.tryCancelling();
            }
        });
        this.buildUI();
        this.pack();
        this.setResizable(false);
        this.setSize(500, this.getHeight());
        this.setLocationRelativeTo(owner);
    }

    private void tryCancelling() {
        boolean res = this.task.cancel();
        if (res) {
            this.dispose();
        }
    }

    private void buildUI() {
        JPanel container = new JPanel();
        container.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        container.setLayout(new BoxLayout(container, 3));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        this.progressBar = new JProgressBar();
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(1000);
        buttonPanel.add(this.progressBar);
        buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.cancelButton = new JButton("Cancel");
        buttonPanel.add(this.cancelButton);
        container.add(buttonPanel);
        JPanel statusPanel = new JPanel();
        statusPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        statusPanel.setLayout(new BoxLayout(statusPanel, 2));
        this.statusLabel = new JLabel("Initializing...", 10);
        statusPanel.add(this.statusLabel);
        statusPanel.add(Box.createHorizontalGlue());
        container.add(statusPanel);
        this.add(container);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressDialog.this.tryCancelling();
            }
        });
        this.pack();
    }

    @Override
    public void titleChanged(final TitleChangeEvent event) {
        final ProgressDialog self = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                self.setTitle(event.getMessage());
            }
        });
    }

    @Override
    public void statusChanged(final StatusChangeEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.statusLabel.setText(event.getMessage());
            }
        });
    }

    @Override
    public void valueChanged(final ValueChangeEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                double value = event.getNewValue();
                if (value < 0.0) {
                    ProgressDialog.this.progressBar.setIndeterminate(true);
                } else {
                    ProgressDialog.this.progressBar.setIndeterminate(false);
                    ProgressDialog.this.progressBar.setValue((int)(value * 1000.0));
                }
            }
        });
    }

    @Override
    public void completed(EventObject eventObject) {
        final ProgressDialog self = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                self.dispose();
            }
        });
    }
}

