/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher;

import com.sk89q.mclauncher.model.Component;
import com.sk89q.mclauncher.model.ComponentTableModel;
import com.sk89q.mclauncher.model.PackageManifest;
import com.sk89q.mclauncher.util.ActionListeners;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;

public class SelectComponentsDialog
extends JDialog {
    private static final long serialVersionUID = -8771235345163527656L;
    private final PackageManifest manifest;
    private JTable table;

    public SelectComponentsDialog(Window owner, PackageManifest manifest) {
        super(owner, "Select Install Options", Dialog.ModalityType.DOCUMENT_MODAL);
        this.manifest = manifest;
        this.setResizable(true);
        this.buildUI();
        this.pack();
        this.setSize(320, 500);
        this.setLocationRelativeTo(owner);
    }

    private void buildUI() {
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout(8, 8));
        container.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JLabel infoLabel = new JLabel("<html>To change these later, select 'Re-select install options' after clicking 'More Options' on the launcher.");
        container.add((java.awt.Component)infoLabel, "North");
        this.table = new JTable(){
            private static final long serialVersionUID = 4897191210730076435L;

            @Override
            public java.awt.Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                java.awt.Component c = super.prepareRenderer(renderer, row, col);
                if (col == 0) {
                    c.setEnabled(!((Component)this.getModel().getValueAt(row, 1)).isRequired());
                }
                return c;
            }
        };
        this.table.setTableHeader(null);
        this.table.setShowGrid(false);
        this.table.setRowHeight(this.table.getRowHeight() + 2);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setFillsViewportHeight(true);
        this.table.setSelectionMode(0);
        this.table.setModel(new ComponentTableModel(this.manifest.getComponents()));
        this.table.getColumnModel().getColumn(0).setMaxWidth(30);
        JScrollPane tableScroll = new JScrollPane(this.table);
        container.add((java.awt.Component)tableScroll, "Center");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout(0, 8));
        container.add((java.awt.Component)bottomPanel, "South");
        JLabel descLabel = new JLabel("<html><b>Description:</b>");
        bottomPanel.add((java.awt.Component)descLabel, "North");
        final JTextArea descArea = new JTextArea("Select an option to see its description."){
            private static final long serialVersionUID = 4339941505774335040L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension((int)super.getPreferredSize().getWidth(), 100);
            }
        };
        descArea.setFont(descLabel.getFont());
        descArea.setBackground(descLabel.getBackground());
        descArea.setEditable(false);
        descArea.setWrapStyleWord(true);
        descArea.setLineWrap(true);
        JScrollPane descScroll = new JScrollPane(descArea, 22, 31);
        bottomPanel.add((java.awt.Component)descScroll, "Center");
        this.add((java.awt.Component)container, "Center");
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Component component = (Component)SelectComponentsDialog.this.table.getModel().getValueAt(SelectComponentsDialog.this.table.getSelectedRow(), 1);
                descArea.setText(component.getDescription());
            }
        });
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout(2, 0, 5));
        JButton installButton = new JButton("Continue...");
        buttonsPanel.add(installButton);
        bottomPanel.add((java.awt.Component)buttonsPanel, "South");
        installButton.addActionListener(ActionListeners.dipose(this));
    }
}

