/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.addons;

import com.sk89q.mclauncher.addons.Addon;
import com.sk89q.mclauncher.util.LauncherUtils;
import com.sk89q.mclauncher.util.SimpleNode;
import com.sk89q.mclauncher.util.XmlUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class AddonsProfile
implements TableModel {
    private File configFile;
    private File dir;
    private List<Addon> addons = new ArrayList<Addon>();
    private EventListenerList listenerList = new EventListenerList();

    public AddonsProfile(File dir) {
        dir.mkdirs();
        this.dir = dir;
        this.configFile = new File(dir, "addons.xml");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void read() throws IOException {
        this.addons = new ArrayList<Addon>();
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(this.configFile));
            Document doc = XmlUtils.parseXml(in);
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression idExpr = xpath.compile("id/text()");
            XPathExpression versionExpr = xpath.compile("version/text()");
            XPathExpression nameExpr = xpath.compile("name/text()");
            XPathExpression filenameExpr = xpath.compile("filename/text()");
            XPathExpression urlExpr = xpath.compile("url/text()");
            XPathExpression enabledExpr = xpath.compile("enabled/text()");
            for (Node node : XmlUtils.getNodes(doc, xpath.compile("/config/addons/addon"))) {
                String filename = XmlUtils.getStringOrNull(node, filenameExpr);
                if (filename == null) continue;
                String id = LauncherUtils.defaultValue(XmlUtils.getStringOrNull(node, idExpr), filename);
                String name = LauncherUtils.defaultValue(XmlUtils.getStringOrNull(node, nameExpr), filename);
                String version = XmlUtils.getStringOrNull(node, versionExpr);
                String urlS = XmlUtils.getStringOrNull(node, urlExpr);
                boolean enabled = XmlUtils.getBool(node, false, enabledExpr);
                URL url = null;
                try {
                    url = new URL(urlS);
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
                File file = new File(this.dir, filename);
                if (!file.exists()) {
                    file = null;
                }
                Addon addon = new Addon(id, name, version, file, url);
                addon.setEnabled(enabled);
                this.addons.add(addon);
            }
            this.fireTableChanged(new TableModelEvent(this));
        }
        catch (FileNotFoundException e) {
            LauncherUtils.close(in);
            return;
            catch (XPathExpressionException e2) {
                try {
                    throw new IOException(e2);
                    catch (ParserConfigurationException e3) {
                        throw new IOException(e3);
                    }
                    catch (SAXException e4) {
                        throw new IOException(e4);
                    }
                }
                catch (Throwable throwable) {
                    LauncherUtils.close(in);
                    throw throwable;
                }
            }
        }
        LauncherUtils.close(in);
    }

    public void write() throws IOException {
        try {
            Document doc = XmlUtils.newXml();
            SimpleNode root = XmlUtils.start(doc, "config");
            SimpleNode addonsNode = root.addNode("addons");
            for (Addon addon : this.addons) {
                SimpleNode addonNode = addonsNode.addNode("addon");
                addonNode.addNode("id").addValue(addon.getId());
                addonNode.addNode("version").addValue(addon.getVersion());
                addonNode.addNode("name").addValue(addon.getName());
                addonNode.addNode("filename").addValue(addon.getFile().getName());
                addonNode.addNode("url").addValue(addon.getUrl() != null ? addon.getUrl().toString() : null);
                addonNode.addNode("enabled").addValue(addon.isEnabled());
            }
            XmlUtils.writeXml(doc, this.configFile);
        }
        catch (TransformerException e) {
            throw new IOException(e);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
    }

    public boolean save() {
        try {
            this.write();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public File getDirectory() {
        return this.dir;
    }

    public boolean isUsing(File file) {
        for (Addon other : this.addons) {
            if (!file.equals(other.getFile())) continue;
            return true;
        }
        return false;
    }

    public boolean hasInstalled(String id) {
        for (Addon other : this.addons) {
            if (!id.equals(other.getId())) continue;
            return true;
        }
        return false;
    }

    public List<Addon> getAddonsOfId(String id) {
        ArrayList<Addon> ret = new ArrayList<Addon>();
        for (Addon addon : this.addons) {
            if (!id.equals(addon.getId())) continue;
            ret.add(addon);
        }
        return ret;
    }

    public boolean add(Addon addon) {
        if (this.addons.add(addon)) {
            this.fireTableChanged(new TableModelEvent(this, this.addons.size() - 1));
            return true;
        }
        return false;
    }

    public boolean moveUp(Addon addon) {
        int index = this.addons.indexOf(addon);
        if (index == -1) {
            throw new IllegalArgumentException("Addon is not in list");
        }
        if (index == 0) {
            return false;
        }
        Collections.rotate(this.addons.subList(index - 1, index + 1), -1);
        this.fireTableChanged(new TableModelEvent(this, index - 1, index + 1));
        return true;
    }

    public boolean moveUp(int lower, int upper) {
        if (upper < lower) {
            throw new IllegalArgumentException("Upper bound must be greater or equal to lower bound");
        }
        if (lower < 0 || upper > this.addons.size()) {
            throw new IllegalArgumentException("Bounds are outside the scope of the list");
        }
        if (lower == 0) {
            return false;
        }
        Collections.rotate(this.addons.subList(lower - 1, upper + 1), -1);
        this.fireTableChanged(new TableModelEvent(this, lower - 1, upper));
        return true;
    }

    public boolean moveDown(Addon addon) {
        int index = this.addons.indexOf(addon);
        if (index == -1) {
            throw new IllegalArgumentException("Addon is not in list");
        }
        if (index == this.addons.size() - 1) {
            return false;
        }
        Collections.rotate(this.addons.subList(index, index + 1), -1);
        this.fireTableChanged(new TableModelEvent(this, index, index + 1));
        return true;
    }

    public boolean moveDown(int lower, int upper) {
        if (upper < lower) {
            throw new IllegalArgumentException("Upper bound must be greater or equal to lower bound");
        }
        if (lower < 0 || upper > this.addons.size()) {
            throw new IllegalArgumentException("Bounds are outside the scope of the list");
        }
        if (upper == this.addons.size() - 1) {
            return false;
        }
        Collections.rotate(this.addons.subList(lower, upper + 2), 1);
        this.fireTableChanged(new TableModelEvent(this, lower, upper + 1));
        return true;
    }

    public boolean remove(Addon addon) {
        int index = this.addons.indexOf(addon);
        if (index == -1) {
            return false;
        }
        if (this.addons.remove(addon)) {
            this.fireTableChanged(new TableModelEvent(this));
            if (addon.getFile() != null) {
                addon.getFile().delete();
            }
        } else {
            throw new IllegalArgumentException("Tried to remove addon that was supposed to existed");
        }
        return true;
    }

    public List<Addon> getEnabledAddons() {
        ArrayList<Addon> enabled = new ArrayList<Addon>();
        for (Addon addon : this.addons) {
            if (!addon.isEnabled()) continue;
            enabled.add(addon);
        }
        return enabled;
    }

    public Addon getAddonAt(int i) {
        return this.addons.get(i);
    }

    @Override
    public int getRowCount() {
        return this.addons.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Enabled";
            }
            case 1: {
                return "Name";
            }
            case 2: {
                return "URL";
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return URL.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Addon addon = this.addons.get(rowIndex);
        if (addon == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return addon.isEnabled();
            }
            case 1: {
                return (addon.getFile() == null ? "<Missing>" : "") + addon.getName();
            }
            case 2: {
                return addon.getUrl();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        Addon addon = this.addons.get(rowIndex);
        if (addon == null) {
            return;
        }
        switch (columnIndex) {
            case 0: {
                addon.setEnabled((Boolean)value);
                break;
            }
            case 1: {
                addon.setName((String)value);
                break;
            }
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listenerList.add(TableModelListener.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listenerList.remove(TableModelListener.class, l);
    }

    private void fireTableChanged(final TableModelEvent event) {
        final Object[] listeners = this.listenerList.getListenerList();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    ((TableModelListener)listeners[i + 1]).tableChanged(event);
                }
            }
        });
    }
}

