/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.config;

import com.sk89q.mclauncher.Launcher;
import com.sk89q.mclauncher.addons.AddonsProfile;
import com.sk89q.mclauncher.config.DefaultJar;
import com.sk89q.mclauncher.config.JarList;
import com.sk89q.mclauncher.config.MinecraftJar;
import com.sk89q.mclauncher.config.ServerEntry;
import com.sk89q.mclauncher.config.SettingsList;
import com.sk89q.mclauncher.session.MinecraftSession;
import com.sk89q.mclauncher.update.ManifestUpdateCheck;
import com.sk89q.mclauncher.update.UpdateCache;
import com.sk89q.mclauncher.update.UpdateCheck;
import com.sk89q.mclauncher.update.UpdateException;
import com.sk89q.mclauncher.update.UpdateManifestFetcher;
import com.sk89q.mclauncher.update.VanillaUpdateCheck;
import com.sk89q.mclauncher.util.LauncherUtils;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.spout.nbt.CompoundMap;
import org.spout.nbt.CompoundTag;
import org.spout.nbt.ListTag;
import org.spout.nbt.Tag;
import org.spout.nbt.stream.NBTInputStream;

public class Configuration
implements Comparable<Configuration> {
    private static final Logger logger = Logger.getLogger(Configuration.class.getCanonicalName());
    public static final Pattern ID_PATTERN = Pattern.compile("^[A-Za-z0-9\\-_\\.]+{1,64}$");
    private String id;
    private String customBasePath;
    private String appDir;
    private String name;
    private URL newsUrl;
    private URL updateUrl;
    private String lastJar;
    private SettingsList settings = new SettingsList();
    private Date lastLaunch;
    private transient JarList jarList;
    private transient boolean builtIn = false;
    private transient boolean checkedIcon;
    private transient BufferedImage cachedIcon;

    public static Configuration createInstance(String id, String name, URL updateUrl) {
        return Configuration.createCustom(id, name, "%INSTANCEDIR%" + File.separator + id, updateUrl);
    }

    public static Configuration createCustom(String id, String name, String dir, URL updateUrl) {
        if (!Configuration.isValidId(id)) {
            throw new IllegalArgumentException("Invalid configuration ID");
        }
        Configuration configuration = new Configuration();
        configuration.setId(id);
        configuration.setName(name);
        configuration.setCustomBasePath(dir);
        configuration.setUpdateUrl(updateUrl);
        return configuration;
    }

    @Deprecated
    public static Configuration createGlobal(String id, String name, String dir, URL updateUrl) {
        if (!Configuration.isValidId(id)) {
            throw new IllegalArgumentException("Invalid configuration ID");
        }
        Configuration configuration = new Configuration();
        configuration.setId(id);
        configuration.setName(name);
        configuration.setAppDir(dir);
        configuration.setUpdateUrl(updateUrl);
        return configuration;
    }

    @XmlElement
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlElement
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement
    public String getAppDir() {
        return this.appDir;
    }

    public void setAppDir(String appDir) {
        if (appDir != null && appDir.isEmpty()) {
            this.appDir = null;
            return;
        }
        if (appDir != null && !appDir.matches("^[A-Za-z0-9\\-_]+{1,32}$")) {
            throw new IllegalArgumentException("Invalid data directory name");
        }
        this.appDir = appDir;
    }

    @XmlElement(name="basePath")
    public String getCustomBasePath() {
        return this.customBasePath;
    }

    public void setCustomBasePath(String customBasePath) {
        if (customBasePath != null && customBasePath.isEmpty()) {
            this.customBasePath = null;
            return;
        }
        this.customBasePath = customBasePath;
    }

    @XmlElement(name="newsURL")
    public URL getNewsUrl() {
        return this.newsUrl;
    }

    public void setNewsUrl(URL newsUrl) {
        this.newsUrl = newsUrl;
    }

    @XmlElement(name="updateURL")
    public URL getUpdateUrl() {
        return this.updateUrl;
    }

    public void setUpdateUrl(URL updateUrl) {
        this.updateUrl = updateUrl;
    }

    @XmlElement(name="lastJar")
    public String getLastJarName() {
        return this.lastJar;
    }

    public void setLastJarName(String lastActiveJar) {
        this.lastJar = lastActiveJar;
    }

    public void setLastJar(MinecraftJar jar) {
        this.setLastJarName(jar instanceof DefaultJar ? null : jar.getName());
    }

    @XmlElement
    public SettingsList getSettings() {
        return this.settings;
    }

    public void setSettings(SettingsList settings) {
        this.settings = settings;
    }

    @XmlElement(name="lastLaunch")
    public Date getLastLaunch() {
        return this.lastLaunch;
    }

    public void setLastLaunch(Date lastLaunch) {
        this.lastLaunch = lastLaunch;
    }

    public void updateLastLaunch() {
        this.setLastLaunch(new Date());
    }

    @XmlTransient
    public boolean isBuiltIn() {
        return this.builtIn;
    }

    public void setBuiltIn(boolean builtIn) {
        this.builtIn = builtIn;
    }

    @XmlTransient
    public boolean isUsingDefaultPath() {
        return this.customBasePath == null && this.appDir == null;
    }

    public UpdateCheck createUpdateCheck(MinecraftSession session, UpdateCache cache) throws UpdateException {
        if (this.updateUrl == null) {
            return VanillaUpdateCheck.fromSession(this, session, cache);
        }
        UpdateManifestFetcher fetcher = new UpdateManifestFetcher(this.updateUrl);
        return new ManifestUpdateCheck(this, cache, fetcher);
    }

    public File getBaseDir() {
        File path = this.getCustomBasePath() != null ? Launcher.replacePathTokens(this.getCustomBasePath()) : (this.getAppDir() == null ? Launcher.getAppDataDir() : Launcher.getAppDataDir(this.getAppDir()));
        path.mkdirs();
        return path;
    }

    public String getDirForOptions() {
        if (this.getCustomBasePath() != null) {
            return this.getCustomBasePath();
        }
        if (this.getAppDir() == null) {
            return Launcher.getAppDataDir().getAbsolutePath();
        }
        return Launcher.getAppDataDir(this.getAppDir()).getAbsolutePath();
    }

    public File getMinecraftDir() {
        File path = this.getCustomBasePath() != null ? Launcher.toMinecraftDir(Launcher.replacePathTokens(this.getCustomBasePath())) : (this.getAppDir() == null ? Launcher.getOfficialDataDir() : Launcher.toMinecraftDir(this.getBaseDir()));
        path.mkdirs();
        return path;
    }

    public File getTexturePacksDir() {
        return new File(this.getMinecraftDir(), "texturepacks");
    }

    @XmlTransient
    public JarList getJars() {
        if (this.jarList == null) {
            this.jarList = new JarList(new File(this.getMinecraftDir(), "bin"));
            this.jarList.setSelectedItem(this.getLastJarName());
        }
        return this.jarList;
    }

    public AddonsProfile getAddonsProfile(String activeJar) {
        return new AddonsProfile(new File(this.getMinecraftDir(), "addons/" + activeJar));
    }

    public BufferedImage getIcon() {
        if (this.cachedIcon == null && !this.checkedIcon) {
            this.checkedIcon = true;
            this.loadIcon();
        }
        return this.cachedIcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Configuration loadIcon() {
        FileInputStream in;
        block5: {
            File iconPath = new File(this.getMinecraftDir(), "skmclauncher_icon.png");
            if (!iconPath.exists()) {
                return null;
            }
            in = null;
            try {
                in = new FileInputStream(iconPath);
                BufferedInputStream bis = new BufferedInputStream(in);
                BufferedImage icon = ImageIO.read(bis);
                if (icon.getWidth() != 32 || icon.getHeight() != 32) break block5;
                this.cachedIcon = icon;
            }
            catch (IOException e) {
                try {
                    logger.warning("Failed to load icon at " + iconPath);
                }
                catch (Throwable throwable) {
                    LauncherUtils.close(in);
                    throw throwable;
                }
                LauncherUtils.close(in);
            }
        }
        LauncherUtils.close(in);
        return this;
    }

    public Configuration loadIcon(String path) {
        InputStream in = Launcher.class.getResourceAsStream(path);
        if (in != null) {
            try {
                this.cachedIcon = ImageIO.read(in);
            }
            catch (IOException e) {
                logger.warning("Failed to load icon at " + path);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServerEntry> detectUserServers() {
        ArrayList<ServerEntry> retn;
        block5: {
            File file = new File(this.getMinecraftDir(), "servers.dat");
            retn = new ArrayList<ServerEntry>();
            try {
                if (!file.exists()) break block5;
                NBTInputStream nbt = null;
                try {
                    nbt = new NBTInputStream(new FileInputStream(file), false);
                    Tag tag = nbt.readTag();
                    ListTag servers = (ListTag)((CompoundMap)tag.getValue()).get("servers");
                    Iterator i$ = servers.getValue().iterator();
                    while (i$.hasNext()) {
                        Object val = i$.next();
                        CompoundMap server = ((CompoundTag)val).getValue();
                        String name = (String)server.get("name").getValue();
                        String ip = (String)server.get("ip").getValue();
                        retn.add(new ServerEntry(name, ip));
                    }
                }
                catch (Throwable throwable) {
                    LauncherUtils.close(nbt);
                    throw throwable;
                }
                LauncherUtils.close(nbt);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return retn;
    }

    public static boolean isValidId(String id) {
        return ID_PATTERN.matcher(id).matches();
    }

    @Override
    public int compareTo(Configuration o) {
        if (this.getLastLaunch() == null && o.getLastLaunch() == null) {
            return 0;
        }
        if (this.getLastLaunch() == null) {
            return 1;
        }
        if (o.getLastLaunch() == null) {
            return -1;
        }
        return -this.getLastLaunch().compareTo(o.getLastLaunch());
    }
}

