/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.config;

import com.sk89q.mclauncher.config.Configuration;
import com.sk89q.mclauncher.config.Constants;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;

public class ConfigurationList
implements Iterable<Configuration>,
TableModel,
ListModel {
    private List<Configuration> configurations = new ArrayList<Configuration>();
    private EventListenerList listenerList = new EventListenerList();

    @XmlElement(name="configuration")
    public List<Configuration> getConfigurations() {
        if (this.configurations.size() == 0) {
            Constants.register(this);
        }
        return this.configurations;
    }

    public void setConfigurations(List<Configuration> configurations) {
        this.configurations = configurations;
        if (configurations.size() == 0) {
            Constants.register(this);
        }
    }

    public Configuration getStartupConfiguration() {
        return this.getConfigurations().get(0);
    }

    public Configuration get(String id) {
        for (Configuration configuration : this.configurations) {
            if (!configuration.getId().equals(id)) continue;
            return configuration;
        }
        return null;
    }

    public void register(Configuration configuration) {
        int index = this.configurations.indexOf(configuration);
        if (index == -1) {
            this.configurations.add(configuration);
            this.fireTableChanged(new TableModelEvent(this, this.configurations.size() - 1));
            this.fireListChanged(new ListDataEvent(this, 1, this.configurations.size() - 1, this.configurations.size() - 1));
        } else {
            this.fireTableChanged(new TableModelEvent(this, index));
            this.fireListChanged(new ListDataEvent(this, 0, 0, this.configurations.size() - 1));
        }
    }

    public boolean remove(Configuration configuration) {
        int index = this.configurations.indexOf(configuration);
        if (index == -1) {
            return false;
        }
        this.configurations.remove(index);
        this.fireTableChanged(new TableModelEvent(this));
        this.fireListChanged(new ListDataEvent(this, 0, 0, this.configurations.size() - 1));
        return true;
    }

    public boolean update(Configuration configuration) {
        int index = this.configurations.indexOf(configuration);
        if (index == -1) {
            return false;
        }
        this.fireTableChanged(new TableModelEvent(this, index));
        this.fireListChanged(new ListDataEvent(this, 0, index, index));
        return true;
    }

    public Configuration registerBuiltIn(String id, String name, String appDir, String urlString) {
        URL url = null;
        try {
            if (urlString != null) {
                url = new URL(urlString);
            }
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        Configuration config = this.get(id);
        if (config == null) {
            config = Configuration.createGlobal(id, name, appDir, url);
            this.register(config);
        }
        config.setName(name);
        config.setAppDir(appDir);
        config.setUpdateUrl(url);
        config.setBuiltIn(true);
        this.register(config);
        return config;
    }

    public void sortByDate() {
        Collections.sort(this.configurations);
        this.fireTableChanged(new TableModelEvent(this));
        this.fireListChanged(new ListDataEvent(this, 0, 0, this.configurations.size() - 1));
    }

    public Configuration getConfigurationAt(int i) {
        return this.configurations.get(i);
    }

    @Override
    public Iterator<Configuration> iterator() {
        return this.configurations.iterator();
    }

    @Override
    public int getRowCount() {
        return this.configurations.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Path";
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Configuration configuration = this.configurations.get(rowIndex);
        if (configuration == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return configuration.getName();
            }
            case 1: {
                return configuration.getBaseDir();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        Configuration configuration = this.configurations.get(rowIndex);
        if (configuration == null) {
            return;
        }
        switch (columnIndex) {
            case 0: {
                configuration.setName((String)value);
                break;
            }
        }
    }

    @Override
    public int getSize() {
        return this.configurations.size();
    }

    public Object getElementAt(int index) {
        return this.configurations.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listenerList.add(ListDataListener.class, l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listenerList.remove(ListDataListener.class, l);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listenerList.add(TableModelListener.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listenerList.remove(TableModelListener.class, l);
    }

    private void fireTableChanged(final TableModelEvent event) {
        final Object[] listeners = this.listenerList.getListenerList();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != TableModelListener.class) continue;
                    ((TableModelListener)listeners[i + 1]).tableChanged(event);
                }
            }
        });
    }

    private void fireListChanged(final ListDataEvent event) {
        final Object[] listeners = this.listenerList.getListenerList();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != ListDataListener.class) continue;
                    ((ListDataListener)listeners[i + 1]).contentsChanged(event);
                }
            }
        });
    }

    void afterUnmarshal(Unmarshaller u, Object parent) {
        Constants.register(this);
        this.sortByDate();
    }
}

