/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.config;

import com.sk89q.mclauncher.Launcher;
import com.sk89q.mclauncher.config.ConfigurationList;
import com.sk89q.mclauncher.security.X509KeyRing;
import com.sk89q.mclauncher.security.X509KeyStore;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.CertificateException;

public class Constants {
    public static final boolean VERIFY_CUSTOM_DOWNLOADS = false;
    public static final URL NEWS_URL;
    private static final String NEWS_URL_BASE = "http://minecraft.update.sk89q.com/updates/?v=%version%";

    private Constants() {
    }

    public static void register(ConfigurationList configsManager) {
        configsManager.registerBuiltIn("minecraft", "Default Minecraft", null, null);
    }

    public static void register(X509KeyRing keyRing) throws CertificateException, IOException {
        X509KeyStore keyStore = keyRing.getKeyStore(X509KeyRing.Ring.MINECRAFT_LOGIN);
        keyStore.addRootCertificates(Launcher.class.getResourceAsStream("/resources/mclogin.cer"));
        keyStore = keyRing.getKeyStore(X509KeyRing.Ring.UPDATE);
        keyStore.addRootCertificates(Launcher.class.getResourceAsStream("/resources/mcupdate.cer"));
        keyStore.addRootCertificates(Launcher.class.getResourceAsStream("/resources/sk89q.cer"));
    }

    static {
        try {
            String urlStr = NEWS_URL_BASE;
            try {
                urlStr = urlStr.replace("%version%", URLEncoder.encode(Launcher.VERSION, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            NEWS_URL = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

