/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.config;

import com.sk89q.mclauncher.Launcher;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import util.Base64;

public class Identity
implements Comparable<Identity> {
    private static final Logger logger = Logger.getLogger(Identity.class.getCanonicalName());
    public static final String MOJANG_ENCRYPTION_PASSWORD = "passwordfile";
    private String id;
    private String key;
    private Date lastLogin;
    private transient String password;

    public Identity() {
    }

    public Identity(String id, String password) {
        this.setId(id);
        this.setPassword(password);
    }

    @XmlElement(name="name")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlElement
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
        this.password = null;
        if (key != null && key.length() > 0) {
            try {
                Cipher cipher = Launcher.getInstance().getCipher(2, MOJANG_ENCRYPTION_PASSWORD);
                byte[] decrypted = cipher.doFinal(Base64.decode(key));
                this.password = new String(decrypted, "UTF-8");
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Failed to decrypt password", e);
            }
        }
    }

    @XmlTransient
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.key = null;
        if (password != null && password.length() > 0) {
            try {
                Cipher cipher = Launcher.getInstance().getCipher(1, MOJANG_ENCRYPTION_PASSWORD);
                byte[] encrypted = cipher.doFinal(password.getBytes());
                this.key = Base64.encodeToString(encrypted, false);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Failed to decrypt password", e);
            }
        }
    }

    @XmlElement(name="lastLogin")
    public Date getLastLogin() {
        return this.lastLogin;
    }

    public void setLastLogin(Date lastLogin) {
        this.lastLogin = lastLogin;
    }

    public void updateLastLogin() {
        this.setLastLogin(new Date());
    }

    public String toString() {
        return this.getId();
    }

    public int hashCode() {
        return this.getId() != null ? this.getId().toLowerCase().hashCode() : -1;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Identity) {
            return this.getId() != null ? this.getId().toLowerCase().equals(((Identity)obj).getId().toLowerCase()) : false;
        }
        return false;
    }

    @Override
    public int compareTo(Identity o) {
        if (this.getLastLogin() == null && o.getLastLogin() == null) {
            return 0;
        }
        if (this.getLastLogin() == null) {
            return 1;
        }
        if (o.getLastLogin() == null) {
            return -1;
        }
        return -this.getLastLogin().compareTo(o.getLastLogin());
    }
}

