/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.config;

import com.sk89q.mclauncher.Launcher;
import com.sk89q.mclauncher.config.Identity;
import com.sk89q.mclauncher.util.LauncherUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.swing.ComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

public class IdentityList
implements ComboBoxModel {
    private transient EventListenerList listenerList = new EventListenerList();
    private boolean hasLoggedIn;
    private String lastId;
    private List<Identity> identities = new ArrayList<Identity>();
    private transient Identity selected;

    @XmlAttribute(name="loggedIn")
    public boolean getHasLoggedIn() {
        return this.hasLoggedIn;
    }

    public void setHasLoggedIn(boolean hasLoggedIn) {
        this.hasLoggedIn = hasLoggedIn;
    }

    @XmlAttribute(name="lastUsed")
    public String getLastUsedId() {
        return this.lastId;
    }

    public void setLastUsedId(String lastId) {
        this.lastId = lastId;
    }

    @XmlElement(name="identity")
    public List<Identity> getIdentities() {
        return this.identities;
    }

    public void setIdentities(List<Identity> identities) {
        this.identities = identities;
    }

    @XmlTransient
    public Identity getFirstShown() {
        Iterator<Identity> it;
        Identity identity = this.byId(this.getLastUsedId());
        if (identity == null && (it = this.getIdentities().iterator()).hasNext()) {
            identity = it.next();
        }
        return identity;
    }

    @XmlTransient
    public Identity getLastUsed() {
        return this.byId(this.getLastUsedId());
    }

    public void setLastUsed(Identity identity) {
        if (identity == null) {
            this.setLastUsedId(null);
        } else {
            this.setLastUsedId(identity.getId());
        }
    }

    public Identity byId(String id) {
        for (Identity identity : this.identities) {
            if (!identity.getId().equalsIgnoreCase(id)) continue;
            return identity;
        }
        return null;
    }

    public Set<String> getIds() {
        HashSet<String> usernames = new HashSet<String>();
        for (Identity identity : this.identities) {
            usernames.add(identity.getId());
        }
        return usernames;
    }

    public String getPassword(String id) {
        Identity identity = this.byId(id);
        if (identity == null) {
            return null;
        }
        return identity.getPassword();
    }

    public void remember(String id, String password) {
        Identity identity = this.byId(id);
        if (identity != null) {
            identity.setId(id);
            identity.setPassword(password);
        } else {
            identity = new Identity(id, password);
            this.identities.add(identity);
        }
        identity.updateLastLogin();
        this.setLastUsedId(id);
    }

    public void forgetPassword(String id) {
        Identity identity = this.byId(id);
        if (identity == null) {
            return;
        }
        identity.setPassword(null);
    }

    public void forget(String id) {
        Iterator<Identity> it = this.identities.iterator();
        while (it.hasNext()) {
            String identityId = it.next().getId();
            if (identityId == null) {
                it.remove();
            }
            if (!identityId.equalsIgnoreCase(id)) continue;
            it.remove();
        }
        if (this.getLastUsedId() != null && this.getLastUsedId().equalsIgnoreCase(id)) {
            this.setLastUsedId(null);
        }
        this.fireListDataEvent(new ListDataEvent(this, 0, 0, this.getSize()));
    }

    public void forgetAll() {
        this.identities.clear();
        this.setLastUsed(null);
        this.fireListDataEvent(new ListDataEvent(this, 0, 0, this.getSize()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void importLogins() {
        block8: {
            String password;
            String username;
            DataInputStream in;
            block7: {
                File file = new File(Launcher.getOfficialDataDir(), "lastlogin");
                if (!file.exists()) {
                    return;
                }
                in = null;
                Cipher cipher = Launcher.getInstance().getCipher(2, "passwordfile");
                in = new DataInputStream(new CipherInputStream(new FileInputStream(file), cipher));
                username = in.readUTF();
                password = in.readUTF();
                if (username.trim().length() != 0) break block7;
                LauncherUtils.close(in);
                return;
            }
            try {
                if (password.trim().length() == 0) {
                    password = null;
                }
                this.remember(username, password);
            }
            catch (Throwable throwable) {
                LauncherUtils.close(in);
                break block8;
                catch (Throwable throwable2) {
                    LauncherUtils.close(in);
                    throw throwable2;
                }
            }
            LauncherUtils.close(in);
        }
    }

    @Override
    public int getSize() {
        return this.getIdentities().size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.getIdentities().get(index);
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item instanceof Identity) {
            this.selected = (Identity)item;
            return;
        }
        String id = String.valueOf(item);
        Identity identity = this.byId(id);
        this.selected = identity != null ? identity : new Identity(id, null);
        this.fireListDataEvent(new ListDataEvent(this, 0, 0, this.getSize()));
    }

    @Override
    @XmlTransient
    public Object getSelectedItem() {
        if (this.selected == null) {
            this.selected = this.getFirstShown();
        }
        return this.selected;
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listenerList.add(ListDataListener.class, l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listenerList.remove(ListDataListener.class, l);
    }

    private void fireListDataEvent(final ListDataEvent event) {
        final Object[] listeners = this.listenerList.getListenerList();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != ListDataListener.class) continue;
                    ((ListDataListener)listeners[i + 1]).contentsChanged(event);
                }
            }
        });
    }

    void afterUnmarshal(Unmarshaller u, Object parent) {
        Collections.sort(this.identities);
    }
}

