/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.config;

import com.sk89q.mclauncher.config.DefaultJar;
import com.sk89q.mclauncher.config.MinecraftJar;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class JarList
implements ComboBoxModel {
    private transient EventListenerList listenerList = new EventListenerList();
    private final File dir;
    private DefaultJar defaultJar;
    private MinecraftJar selected;
    private List<MinecraftJar> jars = new ArrayList<MinecraftJar>();

    public JarList(File dir) {
        this.dir = dir;
        this.update();
    }

    public void update() {
        ArrayList<MinecraftJar> jars = new ArrayList<MinecraftJar>();
        this.defaultJar = new DefaultJar(new File(this.dir, "minecraft.jar"));
        jars.add(this.defaultJar);
        Object[] files = this.dir.listFiles();
        if (files != null) {
            Arrays.sort(files);
            for (Object f : files) {
                String name = ((File)f).getName();
                if (!name.matches("^[^\\/:;]+\\.jar$") || name.equalsIgnoreCase("jinput.jar") || name.equalsIgnoreCase("lwjgl.jar") || name.equalsIgnoreCase("lwjgl_util.jar")) continue;
                jars.add(new MinecraftJar((File)f));
            }
        }
        this.fireListDataEvent(new ListDataEvent(this, 0, 0, this.getSize()));
        this.selected = this.defaultJar;
        this.jars = jars;
    }

    @Override
    public int getSize() {
        return this.jars.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.jars.get(index);
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item == null) {
            this.selected = this.defaultJar;
        } else if (item instanceof MinecraftJar) {
            this.selected = (MinecraftJar)item;
        } else if (item instanceof String) {
            for (MinecraftJar jar : this.jars) {
                if (!jar.getName().equals(item)) continue;
                this.selected = jar;
            }
        }
        this.fireListDataEvent(new ListDataEvent(this, 0, 0, this.getSize()));
    }

    @Override
    public Object getSelectedItem() {
        return this.selected;
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listenerList.add(ListDataListener.class, l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listenerList.remove(ListDataListener.class, l);
    }

    private void fireListDataEvent(final ListDataEvent event) {
        final Object[] listeners = this.listenerList.getListenerList();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != ListDataListener.class) continue;
                    ((ListDataListener)listeners[i + 1]).contentsChanged(event);
                }
            }
        });
    }
}

