/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.config;

import com.sk89q.mclauncher.Launcher;
import com.sk89q.mclauncher.config.ConfigurationList;
import com.sk89q.mclauncher.config.IdentityList;
import com.sk89q.mclauncher.config.ServerList;
import com.sk89q.mclauncher.config.SettingsList;
import com.sk89q.mclauncher.util.LauncherUtils;
import com.sk89q.mclauncher.util.XmlUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="launcher")
public class LauncherOptions {
    private static final Logger logger;
    private static final SettingsList defaultSettings;
    private ConfigurationList configurations = new ConfigurationList();
    private ServerList servers = new ServerList();
    private IdentityList identities = new IdentityList();
    private SettingsList settings = new SettingsList(defaultSettings);
    private transient File file;

    public LauncherOptions() {
    }

    public LauncherOptions(File file) {
        this.setFile(file);
    }

    @XmlElement
    public ConfigurationList getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(ConfigurationList configurations) {
        this.configurations = configurations;
    }

    @XmlElement
    public ServerList getServers() {
        return this.servers;
    }

    public void setServers(ServerList servers) {
        this.servers = servers;
    }

    @XmlElement
    public IdentityList getIdentities() {
        return this.identities;
    }

    public void setIdentities(IdentityList identities) {
        this.identities = identities;
    }

    @XmlElement
    public SettingsList getSettings() {
        return this.settings;
    }

    public void setSettings(SettingsList settings) {
        this.settings = settings;
        settings.setParents(defaultSettings);
    }

    @XmlTransient
    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    private void read(LauncherOptions newOptions) {
        this.setConfigurations(newOptions.configurations);
        this.setIdentities(newOptions.identities);
        this.setSettings(newOptions.settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean load() {
        boolean bl;
        if (this.file == null) {
            throw new RuntimeException("No file was set on this instance");
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            fis = new FileInputStream(this.file);
            bis = new BufferedInputStream(fis);
            LauncherOptions newOptions = XmlUtils.parseJaxb(LauncherOptions.class, bis);
            this.read(newOptions);
            bl = true;
            LauncherUtils.close(bis);
        }
        catch (FileNotFoundException e) {
            boolean bl2 = true;
            return bl2;
        }
        catch (JAXBException e2) {
            logger.log(Level.WARNING, "Failed to load configuration", e2);
            boolean bl3 = false;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            LauncherUtils.close(bis);
            LauncherUtils.close(fis);
            return bl3;
        }
        finally {
            LauncherUtils.close(bis);
            LauncherUtils.close(fis);
        }
        LauncherUtils.close(fis);
        return bl;
    }

    public boolean save() {
        if (this.file == null) {
            throw new RuntimeException("No file was set on this instance");
        }
        try {
            XmlUtils.writeJaxb((Object)this, this.file, LauncherOptions.class);
            return true;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to save configuration", e);
            return false;
        }
        catch (JAXBException e) {
            logger.log(Level.WARNING, "Failed to save configuration", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        SettingsList def;
        logger = Logger.getLogger(LauncherOptions.class.getCanonicalName());
        InputStream in = Launcher.class.getResourceAsStream("/resources/defaults.xml");
        if (in != null) {
            try {
                def = XmlUtils.parseJaxb(SettingsList.class, in);
            }
            catch (JAXBException e) {
                def = null;
                logger.log(Level.WARNING, "Could not read default settings", e);
            }
            finally {
                LauncherUtils.close(in);
            }
        } else {
            def = null;
        }
        defaultSettings = def;
    }
}

