/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.config;

import com.sk89q.mclauncher.config.Setting;
import com.sk89q.mclauncher.util.LauncherUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="settings")
public class SettingsList {
    private List<Setting> internalList = new ArrayList<Setting>();
    private SettingsList[] parents;
    private Map<String, String> settings = new HashMap<String, String>();

    public SettingsList() {
    }

    public SettingsList(SettingsList ... parent) {
        this.parents = parent;
    }

    @XmlElement(name="setting")
    List<Setting> getInternalList() {
        this.internalList.clear();
        for (Map.Entry<String, String> entry : this.settings.entrySet()) {
            Setting setting = new Setting();
            setting.key = entry.getKey();
            setting.value = entry.getValue();
            this.internalList.add(setting);
        }
        return this.internalList;
    }

    void setInternalList(List<Setting> internalList) {
        this.internalList = internalList;
    }

    @XmlTransient
    public Map<String, String> getSettings() {
        return this.settings;
    }

    public void setSettings(Map<String, String> settings) {
        this.settings = settings;
    }

    @XmlTransient
    public SettingsList[] getParents() {
        return this.parents;
    }

    public void setParents(SettingsList ... parent) {
        this.parents = parent;
    }

    public void unset(String name) {
        this.settings.remove(name);
    }

    public boolean has(String name) {
        return this.settings.containsKey(name);
    }

    public void set(String name, String val) {
        if (val == null) {
            this.unset(name);
            return;
        }
        this.settings.put(name, val);
    }

    public void set(String name, boolean val) {
        this.set(name, val ? "true" : "false");
    }

    public void set(String name, int val) {
        this.set(name, String.valueOf(val));
    }

    public void set(String name, long val) {
        this.set(name, String.valueOf(val));
    }

    public void set(String name, double val) {
        this.set(name, String.valueOf(val));
    }

    public void set(String name, float val) {
        this.set(name, String.valueOf(val));
    }

    public void set(String name, Object val) {
        this.set(name, String.valueOf(val));
    }

    public String get(String name) {
        String val = this.settings.get(name);
        if (val == null && this.parents != null) {
            for (int i = this.parents.length - 1; i >= 0; --i) {
                val = this.parents[i].get(name);
                if (val == null) continue;
                return val;
            }
            return null;
        }
        return val;
    }

    public String get(String name, String def) {
        return LauncherUtils.defaultValue(this.get(name), def);
    }

    public boolean getBool(String name, boolean def) {
        String val = this.get(name);
        if (val == null) {
            return def;
        }
        return val.equalsIgnoreCase("true");
    }

    public int getInt(String name, int def) {
        String val = this.get(name);
        if (val == null) {
            return def;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public long getLong(String name, long def) {
        String val = this.get(name);
        if (val == null) {
            return def;
        }
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public double getDouble(String name, double def) {
        String val = this.get(name);
        if (val == null) {
            return def;
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public float getFloat(String name, float def) {
        String val = this.get(name);
        if (val == null) {
            return def;
        }
        try {
            return Float.parseFloat(val);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    void afterUnmarshal(Unmarshaller u, Object parent) {
        this.settings.clear();
        for (Setting setting : this.internalList) {
            this.settings.put(setting.key, setting.value);
        }
    }
}

