/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.launch;

import com.sk89q.mclauncher.launch.LoaderCompat;
import java.applet.Applet;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;

class GameAppletContainer
extends Applet
implements AppletStub {
    private static final Logger logger = Logger.getLogger(GameAppletContainer.class.getCanonicalName());
    private static final long serialVersionUID = 356028256286037416L;
    private Map<String, String> parameters;
    private Applet applet;
    private int context = 0;
    private boolean active = false;
    private LoaderCompat loaderCompat;

    GameAppletContainer(Map<String, String> parameters, Applet applet, LoaderCompat loaderCompat) {
        this.parameters = parameters;
        this.applet = applet;
        this.loaderCompat = loaderCompat;
        this.setLayout(new BorderLayout());
    }

    @Override
    public void start() {
        logger.info("Starting " + this.applet.getClass().getCanonicalName());
        this.applet.setStub(this);
        this.applet.setSize(this.getWidth(), this.getHeight());
        this.add((Component)this.applet, "Center");
        logger.info("Initializing Minecraft...");
        this.applet.init();
        this.active = true;
        this.applet.start();
        this.validate();
        this.loaderCompat.afterStart();
        logger.info("Cave Johnson, we're done here.");
    }

    @Override
    public boolean isActive() {
        if (this.context == 0) {
            this.context = -1;
            try {
                if (this.getAppletContext() != null) {
                    this.context = 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.context == -1) {
            return this.active;
        }
        return super.isActive();
    }

    @Override
    public URL getDocumentBase() {
        try {
            return new URL("http://www.minecraft.net/game/");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public String getParameter(String name) {
        String custom = this.parameters.get(name);
        if (custom != null) {
            return custom;
        }
        try {
            return super.getParameter(name);
        }
        catch (Exception e) {
            this.parameters.put(name, null);
            return null;
        }
    }

    public void replace(Applet applet) {
        applet.stop();
        applet.destroy();
        this.applet = applet;
        this.start();
    }

    @Override
    public void appletResize(int width, int height) {
    }
}

