/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.launch;

import com.sk89q.mclauncher.Launcher;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

class GameFrame
extends JFrame {
    private static final Logger logger = Logger.getLogger(GameFrame.class.getCanonicalName());
    private static final long serialVersionUID = 5499648340202625650L;
    private JPanel wrapper;
    private Applet applet;

    GameFrame(Dimension dim) {
        this.setTitle("Minecraft");
        this.setBackground(Color.BLACK);
        try {
            InputStream in = Launcher.class.getResourceAsStream("/resources/icon.png");
            if (in != null) {
                this.setIconImage(ImageIO.read(in));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.wrapper = new JPanel();
        this.wrapper.setBackground(Color.BLACK);
        this.wrapper.setOpaque(false);
        this.wrapper.setPreferredSize(dim != null ? dim : new Dimension(854, 480));
        this.wrapper.setLayout(new BorderLayout());
        this.add((Component)this.wrapper, "Center");
        this.pack();
        this.setLocationRelativeTo(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                if (GameFrame.this.applet != null) {
                    GameFrame.this.applet.stop();
                    GameFrame.this.applet.destroy();
                }
                System.exit(0);
            }
        });
    }

    public void start(Applet applet) {
        logger.info("Starting " + applet.getClass().getCanonicalName());
        applet.init();
        this.wrapper.add((Component)applet, "Center");
        this.validate();
        applet.start();
    }
}

