/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.launch;

import com.sk89q.mclauncher.Launcher;
import com.sk89q.mclauncher.launch.GameAppletContainer;
import com.sk89q.mclauncher.launch.GameFrame;
import com.sk89q.mclauncher.launch.LaunchException;
import com.sk89q.mclauncher.launch.LoaderCompat;
import com.sk89q.mclauncher.launch.RogueClassLoader;
import com.sk89q.mclauncher.util.BasicArgsParser;
import com.sk89q.mclauncher.util.LauncherUtils;
import com.sk89q.mclauncher.util.SwingHelper;
import java.applet.Applet;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class GameLauncher {
    private static final Logger logger = Logger.getLogger(GameLauncher.class.getCanonicalName());
    private File baseDir;
    private File actualDir;
    private String activeJar;
    private ClassLoader classLoader;
    private Map<String, String> parameters = new HashMap<String, String>();
    private List<String> addonPaths = new ArrayList<String>();
    private Dimension windowDim;

    private GameLauncher(File baseDir, String activeJar) {
        logger.info("SK's Minecraft Launcher, v" + Launcher.VERSION);
        this.logJavaInformation();
        this.baseDir = baseDir;
        this.actualDir = Launcher.toMinecraftDir(baseDir);
        this.activeJar = activeJar;
    }

    private void logJavaInformation() {
        logger.info("-------------------------------------------------");
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        logger.info("Java arguments: " + runtimeBean.getInputArguments());
        logger.info("Library path: " + runtimeBean.getLibraryPath());
        logger.info("-------------------------------------------------");
        logger.info("Java version: " + System.getProperty("java.version"));
        logger.info("Java architecture: " + System.getProperty("sun.arch.data.model"));
        logger.info("JVM: " + runtimeBean.getVmName() + " version " + runtimeBean.getVmVersion() + " (vendor: " + runtimeBean.getVmVendor() + ")");
        MemoryMXBean mem = ManagementFactory.getMemoryMXBean();
        logger.info(String.format("HEAP initial: %d MB", mem.getHeapMemoryUsage().getInit() / 1024L / 1024L));
        logger.info(String.format("HEAP maximum: %d MB", mem.getHeapMemoryUsage().getMax() / 1024L / 1024L));
        logger.info(String.format("NON-HEAP initial: %d MB", mem.getNonHeapMemoryUsage().getInit() / 1024L / 1024L));
        logger.info(String.format("NON-HEAP maximum: %d MB", mem.getNonHeapMemoryUsage().getMax() / 1024L / 1024L));
        logger.info("-------------------------------------------------");
    }

    public void setParameter(String key, String val) {
        this.parameters.put(key, val);
    }

    public void addAddonPath(String path) {
        this.addonPaths.add(path);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public List<String> getAddonPaths() {
        return this.addonPaths;
    }

    private void setupEnvironment() throws LaunchException {
        System.setProperty("org.lwjgl.librarypath", new File(this.actualDir, "bin/natives").getAbsolutePath());
        System.setProperty("net.java.games.input.librarypath", new File(this.actualDir, "bin/natives").getAbsolutePath());
        String expected = this.baseDir.getAbsolutePath();
        System.setProperty("user.home", expected);
        if (!System.getProperty("user.home").equals(expected)) {
            throw new LaunchException("user.home was supposed to be set to '" + expected + "', but it was '" + System.getProperty("user.home") + "'");
        }
        String appData = System.getenv("APPDATA");
        if (appData == null || !appData.equals(expected)) {
            throw new LaunchException("APPDATA was supposed to be set to '" + expected + "', but it was '" + appData + "'");
        }
        System.setProperty("minecraft.applet.WrapperClass", "com.sk89q.mclauncher.launch.GameAppletContainer");
        logger.info("Base directory: " + this.baseDir.getAbsolutePath());
        logger.info("What Minecraft will use: " + this.actualDir.getAbsolutePath());
    }

    private void setupClassLoader() {
        ArrayList<File> files = new ArrayList<File>();
        for (int i = this.addonPaths.size() - 1; i >= 0; --i) {
            String path = this.addonPaths.get(i);
            File f = new File(path);
            if (f.exists()) {
                logger.info("Addon: " + f.getAbsolutePath());
            } else {
                logger.warning("Addon doesn't exist: " + f.getAbsolutePath());
            }
            files.add(f);
        }
        files.add(new File(this.actualDir, "bin/lwjgl.jar"));
        files.add(new File(this.actualDir, "bin/jinput.jar"));
        files.add(new File(this.actualDir, "bin/lwjgl_util.jar"));
        files.add(new File(this.actualDir, "bin/" + this.activeJar));
        logger.info("List of classpath entries generated!");
        URL[] urls = new URL[files.size()];
        int i = 0;
        for (File file : files) {
            try {
                urls[i] = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            logger.info("Classpath: " + urls[i]);
            ++i;
        }
        this.classLoader = new RogueClassLoader(urls);
    }

    public Dimension getWindowDim() {
        return this.windowDim;
    }

    public void setWindowDim(Dimension windowDim) {
        this.windowDim = windowDim;
    }

    private void launch() throws LaunchException {
        GameLauncher self = this;
        this.setupEnvironment();
        this.setupClassLoader();
        logger.info("Now launching...");
        try {
            LoaderCompat loaderCompat = new LoaderCompat(self);
            loaderCompat.installHooks();
            Class<?> cls = this.classLoader.loadClass("net.minecraft.client.MinecraftApplet");
            Applet game = (Applet)cls.newInstance();
            GameFrame frame = new GameFrame(this.windowDim);
            frame.setVisible(true);
            GameAppletContainer container = new GameAppletContainer(this.parameters, game, loaderCompat);
            frame.start(container);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Failed to launch", e);
            SwingHelper.showError(null, "Launch error", "An error occurred while launching: " + e.getMessage() + "\n\n" + LauncherUtils.getStackTrace(e));
        }
    }

    private static void redirectLogger() {
        Logger rootLogger = Logger.getLogger("");
        for (Handler handler : rootLogger.getHandlers()) {
            rootLogger.removeHandler(handler);
        }
        rootLogger.addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                Level level = record.getLevel();
                Throwable t = record.getThrown();
                PrintStream out = t != null || level == Level.SEVERE || level == Level.WARNING ? System.err : System.out;
                out.println(record.getMessage());
                if (t != null) {
                    t.printStackTrace(out);
                }
                out.flush();
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        });
    }

    private static void setLookAndFeel() throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public static void main(String[] args) {
        BasicArgsParser parser = new BasicArgsParser();
        parser.addValueArg("width");
        parser.addValueArg("height");
        System.setErr(System.out);
        BasicArgsParser.ArgsContext context = parser.parse(args);
        try {
            String line;
            if (context.length() < 2) {
                throw new LaunchException("Missing parameters");
            }
            GameLauncher.redirectLogger();
            GameLauncher.setLookAndFeel();
            File dir = new File(context.get(0));
            String jar = context.get(1);
            int windowWidth = context.getInt("width", 854);
            int windowHeight = context.getInt("height", 480);
            GameLauncher launcher = new GameLauncher(dir, jar);
            launcher.setWindowDim(new Dimension(windowWidth, windowHeight));
            launcher.setParameter("stand-alone", "true");
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            while ((line = in.readLine()) != null && line.length() != 0) {
                if ((line = line.trim()).startsWith("@")) {
                    String[] parts = line.split("=", 2);
                    if (parts.length <= 1 || parts[0].length() <= 1) continue;
                    launcher.setParameter(parts[0].substring(1), parts[1]);
                    continue;
                }
                if (!line.startsWith("!") || line.length() <= 1) continue;
                launcher.addAddonPath(line.substring(1).trim());
            }
            launcher.launch();
        }
        catch (LaunchException t) {
            logger.severe(t.getMessage());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingHelper.showError(null, "Minecraft launch error", "An error occurred while launching: " + t.getMessage());
                }
            });
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Failed to start Minecraft", t);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingHelper.showError(null, "Minecraft launch error", "An error occurred while launching: " + t.getMessage() + "\n\n" + LauncherUtils.getStackTrace(t));
                }
            });
        }
    }
}

