/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.launch;

import com.sk89q.mclauncher.Launcher;
import com.sk89q.mclauncher.addons.Addon;
import com.sk89q.mclauncher.addons.AddonsProfile;
import com.sk89q.mclauncher.config.Configuration;
import com.sk89q.mclauncher.config.SettingsList;
import com.sk89q.mclauncher.launch.GameLauncher;
import com.sk89q.mclauncher.session.MinecraftSession;
import com.sk89q.mclauncher.util.ConsoleFrame;
import com.sk89q.mclauncher.util.GameConsoleFrame;
import com.sk89q.mclauncher.util.JavaRuntimeFinder;
import com.sk89q.mclauncher.util.LauncherUtils;
import com.sk89q.mclauncher.util.MessageLog;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;

public class LaunchProcessBuilder {
    private static final Logger logger = Logger.getLogger(LaunchProcessBuilder.class.getCanonicalName());
    private static final Pattern maxPermGenPattern = Pattern.compile("^-XX:MaxPermSize=.*$", 2);
    private final Configuration configuration;
    private final String username;
    private final MinecraftSession session;
    private String activeJar;
    private boolean demo = false;
    private String autoConnect;
    private String runtimePath;
    private String wrapperPath;
    private int minMem = 1024;
    private int maxMem = 1024;
    private String[] extraArgs = new String[0];
    private String extraClasspath;
    private boolean showConsole;
    private boolean relaunch;
    private boolean coloredConsole;
    private boolean consoleKillsProcess;
    private boolean fullScreen;
    private boolean lwjglDebug = false;
    private int windowWidth = 300;
    private int windowHeight = 300;
    private ConsoleFrame consoleFrame;

    public LaunchProcessBuilder(Configuration configuration, MinecraftSession session) {
        this.configuration = configuration;
        this.session = session;
        this.username = session.getUsername();
    }

    public void readSettings(SettingsList settings) {
        this.runtimePath = LauncherUtils.nullEmpty(settings.get("java.runtime"));
        this.wrapperPath = LauncherUtils.nullEmpty(settings.get("java.wrapper-program"));
        this.minMem = settings.getInt("java.min-memory", 128);
        this.maxMem = settings.getInt("java.max-memory", 1024);
        this.extraArgs = settings.get("java.arguments", "").split(" +");
        this.extraClasspath = LauncherUtils.nullEmpty(settings.get("java.classpath"));
        this.showConsole = settings.getBool("java.console", false);
        this.relaunch = settings.getBool("launcher.reopen-after-close", false);
        this.coloredConsole = settings.getBool("console.colored", true);
        this.consoleKillsProcess = settings.getBool("console.kill-process-if-closed", true);
        this.fullScreen = settings.getBool("window.fullscreen", false);
        this.lwjglDebug = settings.getBool("lwjgl.debug", false);
        this.windowWidth = settings.getInt("window.width", 300);
        this.windowHeight = settings.getInt("window.height", 300);
    }

    public String getActiveJar() {
        return this.activeJar;
    }

    public void setActiveJar(String activeJar) {
        this.activeJar = activeJar;
    }

    public boolean isDemo() {
        return this.demo;
    }

    public void setDemo(boolean demo) {
        this.demo = demo;
    }

    public String getAutoConnect() {
        return this.autoConnect;
    }

    public void setAutoConnect(String autoConnect) {
        this.autoConnect = autoConnect;
    }

    public boolean getShowConsole() {
        return this.showConsole;
    }

    public void setShowConsole(boolean showConsole) {
        this.showConsole = showConsole;
    }

    private String getLauncherPath() throws IOException {
        try {
            return Launcher.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        }
        catch (URISyntaxException e) {
            throw new IOException("The path to the launcher could not be discovered.", e);
        }
    }

    public void launch() throws IOException {
        Process proc;
        List<Addon> addons;
        String effectiveRuntimePath = "";
        if (this.runtimePath != null) {
            File test2;
            File test = new File(this.runtimePath);
            if (!test.exists()) {
                throw new IOException("The configured Java runtime path '" + this.runtimePath + "' doesn't exist.");
            }
            if (test.isFile()) {
                test = test.getParentFile();
            }
            if ((test2 = new File(test, "bin")).isDirectory()) {
                test = test2;
            }
            effectiveRuntimePath = test.getAbsolutePath() + File.separator;
            logger.info("Using JRE at " + effectiveRuntimePath);
        } else {
            File foundPath = JavaRuntimeFinder.findBestJavaPath();
            if (foundPath != null) {
                logger.info("Detected JRE at " + foundPath.getAbsolutePath());
                effectiveRuntimePath = foundPath.getAbsolutePath() + File.separator;
            }
        }
        File actualWorkingDirectory = this.configuration.getBaseDir();
        File jarFile = new File(this.configuration.getMinecraftDir(), "bin/" + this.activeJar);
        if (!jarFile.exists()) {
            throw new IOException("Launch failed! Can't find '" + jarFile.getAbsolutePath() + "'.\n\nMaybe force an update?");
        }
        try {
            AddonsProfile addonsProfile = this.configuration.getAddonsProfile(this.activeJar);
            addonsProfile.read();
            addons = addonsProfile.getEnabledAddons();
        }
        catch (IOException e) {
            throw new IOException("Failed to get addons list: " + e.getMessage(), e);
        }
        ArrayList<String> params = new ArrayList<String>();
        if (this.wrapperPath != null) {
            params.add(this.wrapperPath);
        }
        params.add(effectiveRuntimePath + "java");
        if (this.minMem > 0) {
            params.add("-Xms" + this.minMem + "M");
        }
        if (this.maxMem > 0) {
            params.add("-Xmx" + this.maxMem + "M");
        }
        params.add("-Dsun.java2d.noddraw=true");
        params.add("-Dsun.java2d.d3d=false");
        params.add("-Dsun.java2d.opengl=false");
        params.add("-Dsun.java2d.pmoffscreen=false");
        if (this.lwjglDebug) {
            params.add("-Dorg.lwjgl.util.Debug=true");
        }
        boolean userIncreasedPermGen = false;
        for (String arg : this.extraArgs) {
            if ((arg = arg.trim()).length() <= 0) continue;
            params.add(arg);
            if (!maxPermGenPattern.matcher(arg).matches()) continue;
            userIncreasedPermGen = true;
        }
        if (!userIncreasedPermGen) {
            params.add("-XX:MaxPermSize=256M");
        }
        params.add("-classpath");
        params.add(this.getLauncherPath() + (this.extraClasspath != null ? File.pathSeparator + this.extraClasspath : ""));
        params.add(GameLauncher.class.getCanonicalName());
        params.add("-width");
        params.add(String.valueOf(this.windowWidth));
        params.add("-height");
        params.add(String.valueOf(this.windowHeight));
        params.add(actualWorkingDirectory.getAbsolutePath());
        params.add(this.activeJar);
        ProcessBuilder procBuilder = new ProcessBuilder(params);
        procBuilder.environment().put("APPDATA", actualWorkingDirectory.getAbsolutePath());
        try {
            proc = procBuilder.start();
        }
        catch (IOException e) {
            throw new IOException("The game could not be started: " + e.getMessage(), e);
        }
        if (this.showConsole) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LaunchProcessBuilder.this.consoleFrame = new GameConsoleFrame(10000, LaunchProcessBuilder.this.coloredConsole, proc, LaunchProcessBuilder.this.consoleKillsProcess);
                    LaunchProcessBuilder.this.consoleFrame.setVisible(true);
                    MessageLog log = LaunchProcessBuilder.this.consoleFrame.getMessageLog();
                    log.consume(proc.getInputStream());
                    log.consume(proc.getErrorStream(), Color.RED);
                }
            });
        }
        PrintStream out = new PrintStream(new BufferedOutputStream(proc.getOutputStream()));
        out.println("@username=" + this.username);
        out.println("@mppass=" + this.username);
        out.println("@sessionid=" + (this.session.isValid() ? this.session.getSessionId() : ""));
        if (this.demo) {
            out.println("@demo=true");
        }
        if (this.fullScreen) {
            out.println("@fullscreen=true");
        }
        if (this.autoConnect != null) {
            String[] parts = this.autoConnect.split(":", 2);
            if (parts.length == 1) {
                out.println("@server=" + parts[0]);
                out.println("@port=25565");
            } else {
                out.println("@server=" + parts[0]);
                out.println("@port=" + parts[1]);
            }
        }
        for (Addon addon : addons) {
            out.println("!" + addon.getFile().getAbsolutePath());
        }
        out.close();
        if (this.showConsole || this.relaunch) {
            if (this.relaunch) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (!LaunchProcessBuilder.this.showConsole) {
                                LauncherUtils.consumeBlindly(proc.getInputStream());
                                LauncherUtils.consumeBlindly(proc.getErrorStream());
                            }
                            proc.waitFor();
                            if (LaunchProcessBuilder.this.consoleFrame != null) {
                                LaunchProcessBuilder.this.consoleFrame.waitFor();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Launcher.startLauncherFrame();
                    }
                });
                thread.setName("Wait For Game Close");
                thread.start();
            }
        } else {
            System.exit(0);
        }
    }
}

