/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.launch;

import com.sk89q.mclauncher.Launcher;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;

public class LauncherRelauncher
implements Runnable {
    private String originalAppData;

    public LauncherRelauncher(String originalAppData) {
        this.originalAppData = originalAppData;
    }

    @Override
    public void run() {
        String launcherPath;
        try {
            launcherPath = Launcher.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("The path to the launcher could not be discovered.", e);
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add("javaw");
        params.add("-classpath");
        params.add(launcherPath);
        params.add(Launcher.class.getCanonicalName());
        ProcessBuilder procBuilder = new ProcessBuilder(params);
        if (this.originalAppData != null) {
            procBuilder.environment().put("APPDATA", this.originalAppData);
        }
        try {
            procBuilder.start();
        }
        catch (IOException e) {
            throw new RuntimeException("The launcher could not be started: " + e.getMessage(), e);
        }
    }
}

