/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.launch;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import sun.misc.Resource;
import sun.misc.URLClassPath;

public class RogueClassLoader
extends URLClassLoader {
    private static final Logger logger = Logger.getLogger(RogueClassLoader.class.getCanonicalName());
    private URLClassPath urlClassPath;

    public RogueClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
        this.install();
    }

    public RogueClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.install();
    }

    public RogueClassLoader(URL[] urls) {
        super(urls);
        this.install();
    }

    private void install() {
        try {
            Field field = URLClassLoader.class.getDeclaredField("ucp");
            field.setAccessible(true);
            this.urlClassPath = (URLClassPath)field.get(this);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Failed to find 'ucp'", e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Failed to find 'ucp'", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Failed to find 'ucp'", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to find 'ucp'", e);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String path = name.replace('.', '/').concat(".class");
        Resource res = this.urlClassPath.getResource(path, false);
        if (res != null) {
            try {
                return this.defineClass(name, res, true);
            }
            catch (IOException e) {
                throw new ClassNotFoundException(name, e);
            }
        }
        if (name.equals("BaseModMp")) {
            logger.info("(!!) Something requested ModLoaderMP, but you don't have it.");
        } else if (name.equals("BaseMod")) {
            logger.info("(!!) Something requested ModLoader, but you don't have it.");
        }
        throw new ClassNotFoundException(name);
    }

    private Class<?> defineClass(String name, Resource res, boolean verify) throws IOException {
        ByteBuffer buffer;
        int i = name.lastIndexOf(46);
        URL url = res.getCodeSourceURL();
        if (i != -1) {
            String pkgName = name.substring(0, i);
            Package pkg = this.getPackage(pkgName);
            Manifest manifest = res.getManifest();
            if (pkg == null) {
                if (manifest != null) {
                    this.definePackage(pkgName, manifest, url);
                } else {
                    this.definePackage(pkgName, null, null, null, null, null, null, null);
                }
            }
        }
        byte[] bytes = (buffer = res.getByteBuffer()) == null ? res.getBytes() : null;
        CodeSource cs = new CodeSource(url, (Certificate[])null);
        return buffer != null ? this.defineClass(name, buffer, cs) : this.defineClass(name, bytes, 0, bytes.length, cs);
    }
}

