/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.model;

import com.sk89q.mclauncher.model.Archive;
import com.sk89q.mclauncher.model.PackageFile;
import com.sk89q.mclauncher.model.SingleFile;
import com.sk89q.mclauncher.util.LauncherUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="filegroup")
public class FileGroup {
    private String source;
    private String dest;
    private VerificationMethod verify;
    private List<PackageFile> files = new ArrayList<PackageFile>();

    @XmlAttribute
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @XmlAttribute
    public String getDest() {
        return this.dest;
    }

    public void setDest(String dest) {
        this.dest = dest;
    }

    @XmlAttribute
    public VerificationMethod getVerify() {
        return this.verify;
    }

    public void setVerify(VerificationMethod verify) {
        this.verify = verify;
    }

    @XmlElements(value={@XmlElement(name="archive", type=Archive.class), @XmlElement(name="file", type=SingleFile.class)})
    public List<PackageFile> getFiles() {
        return this.files;
    }

    public void setFiles(List<PackageFile> files) {
        this.files = files;
    }

    public long getTotalSize() {
        long totalSize = 0L;
        for (PackageFile file : this.files) {
            totalSize += file.getSize();
        }
        return totalSize;
    }

    public URL getURL(URL baseUrl, PackageFile file) {
        try {
            return LauncherUtils.concat(baseUrl, this.getSource() + file.getFilename());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setDestDir(File dir) {
        for (PackageFile file : this.files) {
            file.setDestDir(new File(dir, this.getDest()));
        }
    }

    public MessageDigest createMessageDigest() throws NoSuchAlgorithmException {
        if (this.getVerify() == null) {
            return null;
        }
        return MessageDigest.getInstance(this.getVerify().name());
    }

    public static enum VerificationMethod {
        MD5;

    }
}

