/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.model;

import com.sk89q.mclauncher.WebpageDialog;
import com.sk89q.mclauncher.WebpagePanel;
import com.sk89q.mclauncher.update.Phase;
import com.sk89q.mclauncher.update.UpdateCache;
import com.sk89q.mclauncher.util.LauncherUtils;
import com.sk89q.mclauncher.util.SwingHelper;
import java.awt.Window;
import java.io.IOException;
import java.net.URL;
import javax.swing.SwingUtilities;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

public class Message {
    private String id;
    private String title;
    private Phase phase;
    private boolean agreement;
    private String version;
    private ContentType type;
    private String content;

    @XmlAttribute
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlElement
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @XmlTransient
    public String getValidatedTitle() {
        if (this.title == null || this.title.trim().isEmpty()) {
            return this.agreement ? "Agreement" : "Information";
        }
        return this.title;
    }

    @XmlTransient
    public String getCacheId() {
        return "/$/com.sk89q.mclauncher.model.Message/" + this.getId();
    }

    @XmlElement
    public Phase getPhase() {
        return this.phase;
    }

    public void setPhase(Phase phase) {
        this.phase = phase;
    }

    @XmlElement
    public boolean isAgreement() {
        return this.agreement;
    }

    public void setAgreement(boolean agreement) {
        this.agreement = agreement;
    }

    @XmlAttribute
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @XmlElement
    public ContentType getType() {
        return this.type;
    }

    public void setType(ContentType type) {
        if (type == null) {
            type = ContentType.URL;
        }
        this.type = type;
    }

    @XmlElement
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean mark(UpdateCache cache) {
        if (this.getId() == null || this.getVersion() == null) {
            return true;
        }
        String id = this.getCacheId();
        String oldVersion = cache.getFileVersion(id);
        if (oldVersion != null && oldVersion.equals(this.getVersion())) {
            cache.touch(id);
            return false;
        }
        cache.setFileVersion(id, this.getVersion());
        return true;
    }

    public WebpagePanel createPanel(URL baseUrl) throws IOException {
        switch (this.getType()) {
            case URL: {
                URL url = LauncherUtils.concat(baseUrl, this.getContent());
                return WebpagePanel.forURL(url, false);
            }
            case HTML: {
                return WebpagePanel.forHTML(this.getContent());
            }
        }
        throw new IOException("Invalid content type");
    }

    public WebpageDialog createDialog(Window owner, URL baseUrl) throws IOException {
        return new WebpageDialog(owner, this.getValidatedTitle(), this.createPanel(baseUrl), this.isAgreement());
    }

    public boolean showDialog(Window owner, URL baseUrl) throws IOException {
        final WebpageDialog dialog = this.createDialog(owner, baseUrl);
        if (SwingUtilities.isEventDispatchThread()) {
            dialog.setVisible(true);
        } else {
            SwingHelper.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    dialog.setVisible(true);
                }
            });
        }
        return !this.isAgreement() || dialog.hasAgreed();
    }

    public static enum ContentType {
        URL,
        HTML;

    }
}

