/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.model;

import com.sk89q.mclauncher.Launcher;
import com.sk89q.mclauncher.model.Component;
import com.sk89q.mclauncher.update.FileStreamFilters;
import com.sk89q.mclauncher.update.UninstallLog;
import com.sk89q.mclauncher.util.LauncherUtils;
import com.sk89q.mclauncher.util.Platform;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;

public abstract class PackageFile {
    private long size;
    private Platform platform;
    private String componentFilter;
    private String filename;
    private String finalFilename;
    private String version;
    private ExistingFilePolicy overwrite;
    private transient boolean ignored;
    private transient String[] filterExts;
    private transient File file;
    private transient File tempFile;

    public void inheritGenericProperties(PackageFile pattern) {
        if (pattern.getComponentFilter() != null) {
            this.setComponentFilter(pattern.getComponentFilter());
        }
        if (pattern.getOverwrite() != null) {
            this.setOverwrite(pattern.getOverwrite());
        }
        if (pattern.getPlatform() != null) {
            this.setPlatform(pattern.getPlatform());
        }
    }

    @XmlAttribute
    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    @XmlAttribute
    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    @XmlAttribute(name="component")
    public String getComponentFilter() {
        return this.componentFilter;
    }

    public void setComponentFilter(String componentFilter) {
        this.componentFilter = componentFilter;
    }

    public boolean matchesFilter(Collection<Component> components) {
        String[] parts;
        String filter = this.getComponentFilter();
        if (filter == null) {
            return true;
        }
        boolean matches = false;
        for (String part : parts = filter.split(",")) {
            if ((part = part.trim()).length() == 0) continue;
            boolean negate = false;
            if (part.charAt(0) == '!') {
                negate = true;
                if ((part = part.substring(1)).length() == 0) continue;
            }
            boolean selected = false;
            for (Component component : components) {
                if (!component.getId().equalsIgnoreCase(part)) continue;
                selected = component.isSelected();
                break;
            }
            if (selected == !negate) {
                matches = true;
                continue;
            }
            return false;
        }
        return matches;
    }

    @XmlValue
    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
        this.parseName();
    }

    @XmlTransient
    public String getFinalFilename() {
        return this.finalFilename;
    }

    @XmlAttribute
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setVersion(byte[] digest) {
        this.version = LauncherUtils.getHexString(digest);
    }

    @XmlAttribute
    public ExistingFilePolicy getOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(ExistingFilePolicy overwrite) {
        this.overwrite = overwrite;
    }

    private void parseName() {
        String[] parts = this.getFilename().split("\\.");
        ArrayList<String> filterExts = new ArrayList<String>();
        StringBuilder s = new StringBuilder();
        for (int i = parts.length - 1; i > 0; --i) {
            String part = parts[i];
            if (FileStreamFilters.get(part) != null) {
                filterExts.add(part);
                continue;
            }
            for (int j = 0; j <= i; ++j) {
                if (j != 0) {
                    s.append(".");
                }
                s.append(parts[j]);
            }
            break;
        }
        this.filterExts = new String[filterExts.size()];
        this.filterExts = filterExts.toArray(this.filterExts);
        this.finalFilename = s.toString();
    }

    @XmlTransient
    public boolean isFiltered() {
        return this.filterExts.length > 0;
    }

    @XmlTransient
    public File getFile() {
        return this.file;
    }

    @XmlTransient
    public File getTempFile() {
        return this.tempFile;
    }

    public void setTempFile(File tempFile) {
        this.tempFile = tempFile;
    }

    @XmlTransient
    public boolean isIgnored() {
        return this.ignored;
    }

    public void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }

    public boolean matchesEnvironment() {
        return this.getPlatform() == null || this.getPlatform() == Platform.UNKNOWN || this.getPlatform() == Launcher.getPlatform();
    }

    @XmlTransient
    public InputStream getInputStream() throws IOException {
        InputStream in = new BufferedInputStream(new FileInputStream(this.getTempFile()));
        for (String filterExt : this.filterExts) {
            in = FileStreamFilters.get(filterExt).filter(in);
        }
        return in;
    }

    public abstract void deploy(UninstallLog var1) throws IOException;

    public void setDestDir(File dir) {
        this.file = new File(dir, this.getFinalFilename());
        if (!this.file.toString().startsWith(dir.toString())) {
            throw new RuntimeException("Path '" + this.file.getAbsolutePath() + "' is not in '" + dir.getAbsolutePath() + "'");
        }
    }

    public static enum ExistingFilePolicy {
        NEVER_OVERWRITE;

    }
}

