/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.model;

import com.sk89q.mclauncher.model.Component;
import com.sk89q.mclauncher.model.FileGroup;
import com.sk89q.mclauncher.model.Message;
import com.sk89q.mclauncher.update.Phase;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="package")
public class PackageManifest {
    private String version;
    private List<Component> components = new ArrayList<Component>();
    private List<FileGroup> fileGroups = new ArrayList<FileGroup>();
    private List<Message> messages = new ArrayList<Message>();

    @XmlAttribute
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @XmlTransient
    public boolean isSupportedVersion() {
        return this.getVersion().matches("^1\\.[012]$");
    }

    @XmlElement(name="component")
    public List<Component> getComponents() {
        return this.components;
    }

    public void setComponents(List<Component> components) {
        this.components = components;
    }

    @XmlElement(name="filegroup")
    public List<FileGroup> getFileGroups() {
        return this.fileGroups;
    }

    public void setFileGroups(List<FileGroup> fileGroups) {
        this.fileGroups = fileGroups;
    }

    @XmlElement(name="message")
    public List<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    public List<Message> getMessages(Phase phase) {
        ArrayList<Message> filtered = new ArrayList<Message>();
        for (Message message : this.getMessages()) {
            if (!message.getPhase().equals((Object)phase)) continue;
            filtered.add(message);
        }
        return filtered;
    }

    public long getTotalSize() {
        long totalSize = 0L;
        for (FileGroup group : this.fileGroups) {
            totalSize += group.getTotalSize();
        }
        return totalSize;
    }

    public void setDestDir(File dir) {
        for (FileGroup group : this.fileGroups) {
            group.setDestDir(dir);
        }
    }

    public int getDownloadCount() {
        int count = 0;
        for (FileGroup group : this.fileGroups) {
            count += group.getFiles().size();
        }
        return count;
    }
}

