/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.security;

import com.sk89q.mclauncher.security.CertificateVerificationException;
import com.sk89q.mclauncher.util.LauncherUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.X509TrustManager;

public class X509KeyStore
implements X509TrustManager {
    private final Set<X509Certificate> rootCerts = new HashSet<X509Certificate>();
    private final Set<X509Certificate> intermediateCerts = new HashSet<X509Certificate>();

    public void addRootCertificate(X509Certificate cert) {
        this.rootCerts.add(cert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRootCertificates(InputStream in) throws CertificateException, IOException {
        try {
            BufferedInputStream bufferedIn = new BufferedInputStream(in);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            while (bufferedIn.available() > 0) {
                Certificate cert = cf.generateCertificate(bufferedIn);
                this.addRootCertificate((X509Certificate)cert);
            }
        }
        finally {
            LauncherUtils.close(in);
        }
    }

    public void addIntermediateCertificate(X509Certificate cert) {
        this.intermediateCerts.add(cert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIntermediateCertificate(InputStream in) throws CertificateException, IOException {
        try {
            BufferedInputStream bufferedIn = new BufferedInputStream(in);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            while (bufferedIn.available() > 0) {
                Certificate cert = cf.generateCertificate(bufferedIn);
                this.addIntermediateCertificate((X509Certificate)cert);
            }
        }
        finally {
            LauncherUtils.close(in);
        }
    }

    public void verify(X509Certificate[] chain) throws CertificateVerificationException, CertPathBuilderException {
        try {
            X509CertSelector selector = new X509CertSelector();
            selector.setCertificate(chain[0]);
            HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
            for (X509Certificate rootCert : this.rootCerts) {
                trustAnchors.add(new TrustAnchor(rootCert, null));
            }
            PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustAnchors, (CertSelector)selector);
            pkixParams.setRevocationEnabled(true);
            pkixParams.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(this.intermediateCerts)));
            pkixParams.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(Arrays.asList(chain))));
            CertPathBuilder builder = CertPathBuilder.getInstance("PKIX");
            builder.build(pkixParams);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CertificateVerificationException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertificateVerificationException(e);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        throw new UnsupportedOperationException("Client certificates are supported");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        for (X509Certificate cert : chain) {
            cert.checkValidity();
            if (!cert.hasUnsupportedCriticalExtension()) continue;
            throw new CertificateException("Unsupported critical extension found");
        }
        try {
            this.verify(chain);
        }
        catch (CertificateVerificationException e) {
            throw new CertificateException("Verification error: " + e.getMessage(), e);
        }
        catch (CertPathBuilderException e) {
            throw new CertificateException(e.getMessage(), e);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

