/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.session;

import com.sk89q.mclauncher.Launcher;
import com.sk89q.mclauncher.security.X509KeyRing;
import com.sk89q.mclauncher.session.MinecraftSession;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class LoginSession
implements MinecraftSession {
    private static final String MINECRAFT_LOGIN_URL = "https://login.minecraft.net/";
    private static final String LAUNCHER_VERSION = "13";
    private String username;
    private URL loginURL;
    private boolean isValid;
    private String latestVersion;
    private String downloadTicket;
    private String sessionId;

    public LoginSession(String username) {
        this.username = username;
        try {
            this.loginURL = new URL(MINECRAFT_LOGIN_URL);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void login(String password) throws IOException, MinecraftSession.OutdatedLauncherException, MinecraftSession.LoginException, MinecraftSession.UserNotPremiumException {
        block15: {
            HttpsURLConnection conn = null;
            String params = String.format("user=%s&password=%s&version=%s", URLEncoder.encode(this.username, "UTF-8"), URLEncoder.encode(password, "UTF-8"), URLEncoder.encode(LAUNCHER_VERSION, "UTF-8"));
            TrustManager[] trustManagers = new TrustManager[]{Launcher.getInstance().getKeyRing().getKeyStore(X509KeyRing.Ring.MINECRAFT_LOGIN)};
            try {
                conn = (HttpsURLConnection)this.loginURL.openConnection();
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(null, trustManagers, null);
                conn.setSSLSocketFactory(ctx.getSocketFactory());
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                conn.setRequestProperty("Content-Length", Integer.toString(params.getBytes().length));
                conn.setRequestProperty("Content-Language", "en-US");
                conn.setUseCaches(false);
                conn.setDoInput(true);
                conn.setDoOutput(true);
                conn.setReadTimeout(600000);
                conn.connect();
                DataOutputStream out = new DataOutputStream(conn.getOutputStream());
                out.writeBytes(params);
                out.flush();
                out.close();
                if (conn.getResponseCode() != 200) {
                    throw new IOException("Did not get expected 200 code");
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                StringBuilder s = new StringBuilder();
                char[] buf = new char[1024];
                int len = 0;
                while ((len = reader.read(buf)) != -1) {
                    s.append(buf, 0, len);
                }
                String result = s.toString();
                if (result.contains(":")) {
                    String[] values = result.split(":");
                    try {
                        this.latestVersion = values[0].trim();
                        this.downloadTicket = values[1].trim();
                        this.username = values[2].trim();
                        this.sessionId = values[3].trim();
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new MinecraftSession.LoginException("Returned login payload had an incorrect number of arguments");
                    }
                    this.isValid = true;
                    break block15;
                }
                if (result.trim().equals("Bad login")) {
                    throw new MinecraftSession.InvalidCredentialsException();
                }
                if (result.trim().equals("User not premium")) {
                    throw new MinecraftSession.UserNotPremiumException();
                }
                if (result.trim().equals("Old version")) {
                    throw new MinecraftSession.OutdatedLauncherException();
                }
                throw new MinecraftSession.LoginException(result.trim());
            }
            catch (KeyManagementException e) {
                throw new MinecraftSession.LoginException("Failed to process PKI keys: " + e.getMessage(), e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new MinecraftSession.LoginException("Failed to initiate TLS: " + e.getMessage(), e);
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
                conn = null;
            }
        }
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public String getDownloadTicket() {
        return this.downloadTicket;
    }

    public URL getLoginURL() {
        return this.loginURL;
    }
}

