/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.update;

import com.sk89q.mclauncher.update.StreamFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import lzma.sdk.lzma.Decoder;
import lzma.streams.LzmaInputStream;

public class FileStreamFilters {
    private static Map<String, StreamFilter> filters = new HashMap<String, StreamFilter>();

    public static void register(String ext, StreamFilter filter) {
        filters.put(ext.toLowerCase(), filter);
    }

    public static StreamFilter get(String ext) {
        return filters.get(ext.toLowerCase());
    }

    static {
        FileStreamFilters.register("lzma", new StreamFilter(){

            @Override
            public InputStream filter(InputStream stream) throws IOException {
                return new LzmaInputStream(stream, new Decoder());
            }
        });
        FileStreamFilters.register("gz", new StreamFilter(){

            @Override
            public InputStream filter(InputStream stream) throws IOException {
                return new GZIPInputStream(stream);
            }
        });
    }
}

