/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.update;

import com.sk89q.mclauncher.Launcher;
import com.sk89q.mclauncher.config.Configuration;
import com.sk89q.mclauncher.model.PackageManifest;
import com.sk89q.mclauncher.model.UpdateManifest;
import com.sk89q.mclauncher.update.PackageManifestUpdater;
import com.sk89q.mclauncher.update.UpdateCache;
import com.sk89q.mclauncher.update.UpdateCheck;
import com.sk89q.mclauncher.update.UpdateException;
import com.sk89q.mclauncher.update.UpdateManifestFetcher;
import com.sk89q.mclauncher.update.Updater;
import com.sk89q.mclauncher.util.LauncherUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;

public class ManifestUpdateCheck
implements UpdateCheck {
    private final Configuration configuration;
    private final UpdateCache cache;
    private final UpdateManifestFetcher fetcher;

    public ManifestUpdateCheck(Configuration configuration, UpdateCache cache, UpdateManifestFetcher fetcher) {
        this.configuration = configuration;
        this.cache = cache;
        this.fetcher = fetcher;
    }

    @Override
    public boolean needsUpdate() throws InterruptedException, UpdateException {
        try {
            this.fetcher.downloadManifest();
        }
        catch (UnknownHostException e) {
            throw new UpdateException("Host is unresolved: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new UpdateException(e.getMessage(), e);
        }
        try {
            this.configuration.setNewsUrl(this.fetcher.getManifest().toNewsURL(this.fetcher.getUpdateURL()));
            Launcher.getInstance().getOptions().save();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return this.cache.getLastUpdateId() == null || !this.cache.getLastUpdateId().equals(this.fetcher.getManifest().getLatestVersion());
    }

    @Override
    public Updater createUpdater() throws UpdateException {
        PackageManifest packageManifest;
        try {
            this.fetcher.downloadManifest();
        }
        catch (IOException e) {
            throw new UpdateException("Could not fetch the update manifest (" + e.getMessage() + "). The update cannot be performed.");
        }
        URL packageUrl = null;
        UpdateManifest updateManifest = this.fetcher.getManifest();
        try {
            packageUrl = updateManifest.toPackageURL(this.fetcher.getUpdateURL());
        }
        catch (MalformedURLException e) {
            throw new UpdateException("Invalid URL: " + updateManifest.getPackageURL());
        }
        HttpURLConnection conn = null;
        InputStream is = null;
        try {
            conn = (HttpURLConnection)packageUrl.openConnection();
            conn.setRequestMethod("GET");
            conn.setUseCaches(false);
            conn.setDoInput(true);
            conn.setDoOutput(false);
            conn.setReadTimeout(5000);
            conn.connect();
            if (conn.getResponseCode() != 200) {
                throw new IOException("Did not get expected 200 code");
            }
            is = conn.getInputStream();
            packageManifest = PackageManifestUpdater.parsePackage(is);
        }
        catch (IOException e) {
            try {
                throw new UpdateException("Could not fetch the package manifest (" + e.getMessage() + "). The update cannot be performed.");
            }
            catch (Throwable throwable) {
                LauncherUtils.close(is);
                if (conn != null) {
                    conn.disconnect();
                }
                conn = null;
                throw throwable;
            }
        }
        LauncherUtils.close(is);
        if (conn != null) {
            conn.disconnect();
        }
        conn = null;
        return new PackageManifestUpdater(packageUrl, packageManifest, this.configuration.getMinecraftDir(), this.cache, updateManifest.getLatestVersion());
    }
}

