/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.update;

import com.sk89q.mclauncher.Launcher;
import com.sk89q.mclauncher.SelectComponentsDialog;
import com.sk89q.mclauncher.event.DownloadListener;
import com.sk89q.mclauncher.event.DownloadProgressEvent;
import com.sk89q.mclauncher.event.ProgressListener;
import com.sk89q.mclauncher.event.StatusChangeEvent;
import com.sk89q.mclauncher.event.TitleChangeEvent;
import com.sk89q.mclauncher.event.ValueChangeEvent;
import com.sk89q.mclauncher.model.Component;
import com.sk89q.mclauncher.model.FileGroup;
import com.sk89q.mclauncher.model.Message;
import com.sk89q.mclauncher.model.PackageFile;
import com.sk89q.mclauncher.model.PackageManifest;
import com.sk89q.mclauncher.update.Phase;
import com.sk89q.mclauncher.update.UninstallLog;
import com.sk89q.mclauncher.update.UpdateCache;
import com.sk89q.mclauncher.update.UpdateException;
import com.sk89q.mclauncher.update.Updater;
import com.sk89q.mclauncher.util.Downloader;
import com.sk89q.mclauncher.util.LauncherUtils;
import com.sk89q.mclauncher.util.URLConnectionDownloader;
import com.sk89q.mclauncher.util.XmlUtils;
import java.awt.Window;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;

public class PackageManifestUpdater
implements Updater,
DownloadListener {
    private static final Logger logger = Logger.getLogger(PackageManifestUpdater.class.getCanonicalName());
    private final URL baseUrl;
    private final PackageManifest manifest;
    private final File rootDir;
    private final UpdateCache cache;
    private final EventListenerList listenerList = new EventListenerList();
    private final File downloadDir;
    private final long totalEstimatedSize;
    private final int numFiles;
    private Window owner;
    private int downloadTries = 5;
    private long retryDelay = 2000L;
    private boolean forced = false;
    private String targetVersion;
    private double subprogressOffset = 0.0;
    private double subprogressSize = 1.0;
    private Downloader downloader;
    private int currentIndex = 0;
    private long downloadedEstimatedSize = 0L;

    public PackageManifestUpdater(URL baseUrl, PackageManifest manifest, File targetDir, UpdateCache cache, String targetVersion) {
        this.baseUrl = baseUrl;
        this.manifest = manifest;
        this.rootDir = targetDir;
        this.cache = cache;
        this.downloadDir = new File(this.rootDir, "_download");
        this.targetVersion = targetVersion;
        this.downloadDir.mkdirs();
        manifest.setDestDir(this.rootDir);
        this.totalEstimatedSize = manifest.getTotalSize();
        this.numFiles = manifest.getDownloadCount();
    }

    private URL getURL(FileGroup group, PackageFile file) {
        return group.getURL(this.baseUrl, file);
    }

    private boolean matchesDigest(String s1, String s2) {
        return s1.replaceAll("^0+", "").equalsIgnoreCase(s2.replaceAll("^0+", ""));
    }

    private void showMessages(Phase phase) throws UpdateException, InterruptedException {
        for (Message message : this.manifest.getMessages(phase)) {
            if (!message.mark(this.cache)) continue;
            try {
                if (message.showDialog(this.getOwner(), this.baseUrl)) continue;
                throw new UpdateException("The update has been cancelled.");
            }
            catch (IOException e) {
                throw new UpdateException("Failed to show message dialog due to error in package manifest", e);
            }
        }
    }

    private void downloadFiles() throws UpdateException, InterruptedException {
        this.currentIndex = -1;
        for (FileGroup group : this.manifest.getFileGroups()) {
            for (PackageFile file : group.getFiles()) {
                LauncherUtils.checkInterrupted();
                ++this.currentIndex;
                if (!file.matchesEnvironment()) {
                    logger.info(this.getURL(group, file) + " does NOT match environment");
                    continue;
                }
                if (!file.matchesFilter(this.manifest.getComponents())) {
                    logger.info(this.getURL(group, file) + " does NOT match filter");
                    continue;
                }
                int retryNum = 0;
                Throwable e = null;
                for (int trial = 0; trial < this.downloadTries; ++trial) {
                    LauncherUtils.checkInterrupted();
                    logger.info("Downloading " + this.getURL(group, file) + "...");
                    this.fireStatusChange(String.format("Downloading %s (%d/%d) [try %d]...", file.getFile().getName(), this.currentIndex + 1, this.numFiles, trial + 1));
                    this.fireAdjustedValueChange((double)this.downloadedEstimatedSize / (double)this.totalEstimatedSize);
                    e = this.downloadFile(group, file);
                    if (e == null) break;
                    this.fireDownloadStatusChange("Download failed; retrying (" + ++retryNum + ")...");
                    Launcher.showConsole();
                    logger.warning("Failed to download " + this.getURL(group, file));
                    Thread.sleep(this.retryDelay);
                }
                if (e != null) {
                    throw new UpdateException("Could not download " + file + ": " + e.getMessage(), e);
                }
                this.downloadedEstimatedSize += file.getSize();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Exception downloadFile(FileGroup group, PackageFile file) throws UpdateException, InterruptedException {
        BufferedOutputStream out;
        MessageDigest digest = null;
        URL url = this.getURL(group, file);
        String cacheId = this.getCacheId(file);
        String lastVersion = this.cache.getFileVersion(cacheId);
        this.cache.touch(cacheId);
        if (!this.forced) {
            try {
                digest = group.createMessageDigest();
            }
            catch (NoSuchAlgorithmException e) {
                throw new UpdateException("Unknown digest algorithm: " + e.getMessage());
            }
        }
        LauncherUtils.checkInterrupted();
        File tempFile = new File(this.downloadDir, "_" + LauncherUtils.getDigestAsHex(url.toExternalForm(), "MD5"));
        File downloadFile = new File(tempFile.getAbsoluteFile() + ".download");
        file.setTempFile(tempFile);
        try {
            out = new BufferedOutputStream(new FileOutputStream(downloadFile));
        }
        catch (IOException e) {
            throw new UpdateException("Could not write to " + tempFile.getAbsolutePath() + ".", e);
        }
        LauncherUtils.checkInterrupted();
        try {
            this.downloader = new URLConnectionDownloader(url, out);
            this.downloader.addDownloadListener(this);
            boolean needsUpdate = true;
            if (!this.forced && file.getVersion() != null) {
                if (lastVersion != null && lastVersion.equals(file.getVersion())) {
                    needsUpdate = false;
                }
            } else if (digest != null) {
                this.downloader.setMessageDigest(digest);
                this.downloader.setEtagCheck(this.cache.getFileVersion(cacheId));
            }
            LauncherUtils.checkInterrupted();
            if (needsUpdate) {
                if (digest == null && tempFile.exists()) {
                    logger.info("Found file already downloaded at " + tempFile.getAbsolutePath());
                } else {
                    logger.info("Downloading to " + downloadFile.getAbsolutePath() + "...");
                    LauncherUtils.checkInterrupted();
                    if (this.downloader.download()) {
                        tempFile.delete();
                        downloadFile.renameTo(tempFile);
                    } else {
                        needsUpdate = false;
                    }
                }
            }
            LauncherUtils.checkInterrupted();
            if (needsUpdate) {
                String storedVersion = null;
                if (digest != null) {
                    String signature = new BigInteger(1, digest.digest()).toString(16);
                    if (!this.matchesDigest(this.downloader.getEtag(), signature)) {
                        throw new UpdateException(String.format("Signature for %s did not match; expected %s, got %s", this.getURL(group, file), this.downloader.getEtag(), signature));
                    }
                    storedVersion = signature;
                }
                if (file.getVersion() != null) {
                    storedVersion = file.getVersion();
                }
                if (file.getOverwrite() != null) {
                    storedVersion = lastVersion;
                }
                this.cache.setFileVersion(cacheId, storedVersion);
            } else {
                file.setIgnored(true);
            }
            Exception exception = null;
            return exception;
        }
        catch (IOException e) {
            IOException iOException = e;
            return iOException;
        }
        finally {
            this.downloader = null;
            LauncherUtils.close(out);
            downloadFile.delete();
        }
    }

    private void deploy(UninstallLog log) throws UpdateException, InterruptedException {
        this.currentIndex = -1;
        for (FileGroup group : this.manifest.getFileGroups()) {
            for (PackageFile file : group.getFiles()) {
                LauncherUtils.checkInterrupted();
                logger.info("Installing " + file.getFile().getAbsolutePath());
                ++this.currentIndex;
                if (!file.matchesEnvironment() || !file.matchesFilter(this.manifest.getComponents()) || file.isIgnored()) continue;
                this.fireAdjustedValueChange(this.currentIndex / this.numFiles);
                this.fireStatusChange(String.format("Installing %s (%d/%d)...", file.getFile().getName(), this.currentIndex + 1, this.numFiles));
                try {
                    file.getFile().getParentFile().mkdirs();
                    file.deploy(log);
                }
                catch (SecurityException e) {
                    logger.log(Level.WARNING, "Failed to deploy " + file, e);
                    throw new UpdateException("The digital signature(s) of " + file.getFile().getAbsolutePath() + " could not be verified: " + e.getMessage(), e);
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Failed to deploy " + file, e);
                    throw new UpdateException("Could not install to " + file.getFile().getAbsolutePath() + ": " + e.getMessage(), e);
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "Failed to deploy " + file, e);
                    throw new UpdateException("Could not install " + file.getFile().getAbsolutePath() + ": " + e.getMessage(), e);
                }
            }
        }
    }

    private void deleteOldFiles(UninstallLog oldLog, UninstallLog newLog) throws UpdateException, InterruptedException {
        for (FileGroup fileGroup : this.manifest.getFileGroups()) {
            for (PackageFile file : fileGroup.getFiles()) {
                LauncherUtils.checkInterrupted();
                if (!file.isIgnored()) continue;
                newLog.copyGroupFrom(oldLog, file.getFile());
            }
        }
        for (Map.Entry entry : oldLog.getEntrySet()) {
            for (String path : (Set)entry.getValue()) {
                LauncherUtils.checkInterrupted();
                if (newLog.has(path)) continue;
                new File(this.rootDir, path).delete();
            }
        }
    }

    private void askComponents() {
        boolean needsDialog = false;
        for (Component component : this.manifest.getComponents()) {
            if (component.isRequired()) continue;
            needsDialog = true;
            this.cache.recallSelection(component);
        }
        if (needsDialog) {
            this.fireStatusChange("Asking for install options...");
            SelectComponentsDialog dialog = new SelectComponentsDialog(this.owner, this.manifest);
            dialog.setVisible(true);
        }
        for (Component component : this.manifest.getComponents()) {
            if (component.isRequired()) continue;
            this.cache.storeSelection(component);
        }
    }

    @Override
    public void update(Updater.UpdateType type) throws UpdateException, InterruptedException {
        this.forced = type != Updater.UpdateType.INCREMENTAL;
        File logFile = new File(this.rootDir, "uninstall.dat");
        this.showMessages(Phase.INITIALIZE);
        this.askComponents();
        if (this.forced) {
            try {
                LauncherUtils.cleanDir(this.downloadDir);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        logger.info("Downloading files...");
        this.fireStatusChange("Downloading files...");
        this.setSubprogress(0.0, 0.95);
        this.showMessages(Phase.PRE_DOWNLOAD);
        this.downloadFiles();
        this.showMessages(Phase.POST_DOWNLOAD);
        UninstallLog oldLog = new UninstallLog();
        UninstallLog newLog = new UninstallLog();
        newLog.setBaseDir(this.rootDir);
        try {
            oldLog.read(logFile);
        }
        catch (IOException e) {
            // empty catch block
        }
        logger.info("Installing...");
        this.fireStatusChange("Installing...");
        this.setSubprogress(0.95, 0.05);
        this.showMessages(Phase.PRE_INSTALL);
        this.deploy(newLog);
        this.showMessages(Phase.POST_INSTALL);
        logger.info("Removing old files...");
        this.fireStatusChange("Removing old files...");
        this.deleteOldFiles(oldLog, newLog);
        try {
            newLog.write(logFile);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to write " + logFile, e);
            throw new UpdateException("The uninstall log file could not be written to. The update has been aborted.", e);
        }
        try {
            LauncherUtils.cleanDir(this.downloadDir);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.downloadDir.delete();
        this.showMessages(Phase.FINALIZE);
        this.cache.setLastUpdateId(this.targetVersion);
        try {
            this.cache.write();
        }
        catch (IOException e) {
            throw new UpdateException("Failed to save update cache");
        }
    }

    private PackageFile getCurrentFile() {
        int index = 0;
        for (FileGroup group : this.manifest.getFileGroups()) {
            for (PackageFile file : group.getFiles()) {
                if (index == this.currentIndex) {
                    return file;
                }
                ++index;
            }
        }
        return null;
    }

    private void fireDownloadStatusChange(String message) {
        this.fireStatusChange(String.format("(%d left) %s: %s", this.numFiles - this.currentIndex, this.getCurrentFile().getFile().getName(), message));
    }

    @Override
    public void connectionStarted(EventObject event) {
        this.fireDownloadStatusChange("Connected.");
    }

    @Override
    public void lengthKnown(EventObject event) {
    }

    @Override
    public void downloadProgress(DownloadProgressEvent event) {
        long total = ((Downloader)event.getSource()).getTotalLength();
        PackageFile download = this.getCurrentFile();
        if (total > 0L) {
            this.fireDownloadStatusChange(String.format("Downloaded %,d/%,d KB...", event.getDownloadedLength() / 1024L, total / 1024L));
            this.fireAdjustedValueChange((double)this.downloadedEstimatedSize / (double)this.totalEstimatedSize + (double)download.getSize() / (double)this.totalEstimatedSize * ((double)event.getDownloadedLength() / (double)total));
        } else {
            this.fireDownloadStatusChange(String.format("Downloaded %,d KB...", event.getDownloadedLength() / 1024L));
        }
    }

    @Override
    public void downloadCompleted(EventObject event) {
        this.fireDownloadStatusChange("Download completed.");
        this.fireAdjustedValueChange((double)this.downloadedEstimatedSize / (double)this.totalEstimatedSize + (double)this.getCurrentFile().getSize() / (double)this.totalEstimatedSize);
    }

    protected void setSubprogress(double offset, double size) {
        this.subprogressOffset = offset;
        this.subprogressSize = size;
    }

    protected void fireTitleChange(String message) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((ProgressListener)listeners[i + 1]).titleChanged(new TitleChangeEvent(this, message));
        }
    }

    protected void fireStatusChange(String message) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((ProgressListener)listeners[i + 1]).statusChanged(new StatusChangeEvent(this, message));
        }
    }

    protected void fireValueChange(double value) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((ProgressListener)listeners[i + 1]).valueChanged(new ValueChangeEvent(this, value));
        }
    }

    protected void fireAdjustedValueChange(double value) {
        this.fireValueChange(value * this.subprogressSize + this.subprogressOffset);
    }

    private String getRelative(File base, File path) {
        return base.toURI().relativize(path.toURI()).getPath();
    }

    private String getCacheId(PackageFile file) {
        return this.getRelative(this.rootDir, file.getFile());
    }

    @Override
    public void addProgressListener(ProgressListener l) {
        this.listenerList.add(ProgressListener.class, l);
    }

    @Override
    public void removeProgressListener(ProgressListener l) {
        this.listenerList.remove(ProgressListener.class, l);
    }

    @Override
    public Window getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Window owner) {
        this.owner = owner;
    }

    public static PackageManifest parsePackage(InputStream is) throws UpdateException {
        try {
            PackageManifest manifest = XmlUtils.parseJaxb(PackageManifest.class, is);
            if (!manifest.isSupportedVersion()) {
                throw new UpdateException("The update package is written in an unsupported version. (Update launcher?)");
            }
            return manifest;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Failed to read package file", e);
            throw new UpdateException("Could not read package.xml file. The update cannot continue.\n\nThe error: " + e.getMessage(), e);
        }
    }
}

