/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.update;

import com.sk89q.mclauncher.security.CertificateVerificationException;
import com.sk89q.mclauncher.security.X509KeyStore;
import com.sk89q.mclauncher.util.LauncherUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertPathBuilderException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class SignatureVerifier {
    private X509KeyStore keyStore;

    public SignatureVerifier(X509KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public void verify(Certificate[] certs) throws SecurityException {
        try {
            this.keyStore.verify((X509Certificate[])certs);
        }
        catch (CertPathBuilderException e) {
            throw new SecurityException("Digital signature verification failed: " + e.getMessage());
        }
        catch (CertificateVerificationException e) {
            throw new SecurityException("Digital signature verification failed: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verify(InputStream in, String ext) throws SecurityException, IOException {
        block4: {
            try {
                if (ext.equalsIgnoreCase("jar") || ext.equalsIgnoreCase("zip")) {
                    this.verifyJar(in);
                    break block4;
                }
                throw new SecurityException("Not sure how to verify the signature for '" + ext + "'");
            }
            finally {
                LauncherUtils.close(in);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyJar(InputStream in) throws IOException {
        JarInputStream jarFile = null;
        try {
            JarEntry entry;
            jarFile = new JarInputStream(in);
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                throw new SecurityException("The given file was not digitally signed");
            }
            byte[] buffer = new byte[8192];
            while ((entry = jarFile.getNextJarEntry()) != null) {
                Certificate[] chain;
                if (entry.isDirectory()) continue;
                while (jarFile.read(buffer, 0, buffer.length) != -1) {
                }
                Certificate[] certs = entry.getCertificates();
                if (SignatureVerifier.isMetaInf(entry.getName())) continue;
                if (certs == null || certs.length == 0) {
                    throw new SecurityException("The archive contains files that are not digitally signed");
                }
                boolean verified = false;
                for (int i = 0; i < certs.length; i += chain.length) {
                    chain = SignatureVerifier.findChain(certs, i);
                    try {
                        this.verify(chain);
                        verified = true;
                        break;
                    }
                    catch (SecurityException e) {
                        continue;
                    }
                }
                if (verified) continue;
                throw new SecurityException("The file(s) are signed by an entity that is not registered as 'trusted' with the launcher");
            }
        }
        catch (Throwable throwable) {
            LauncherUtils.close(jarFile);
            throw throwable;
        }
        LauncherUtils.close(jarFile);
    }

    public static X509Certificate[] findChain(Certificate[] seq, int startIndex) {
        int i = 0;
        for (i = startIndex; i < seq.length - 1 && !((X509Certificate)seq[i + 1]).getSubjectDN().equals(((X509Certificate)seq[i]).getIssuerDN()); ++i) {
        }
        X509Certificate[] chain = new X509Certificate[i - startIndex + 1];
        for (int j = 0; j < chain.length; ++j) {
            chain[j] = (X509Certificate)seq[startIndex + j];
        }
        return chain;
    }

    private static boolean isMetaInf(String name) {
        for (String part : name.split("[/\\\\]")) {
            if (!part.equalsIgnoreCase("META-INF")) continue;
            return true;
        }
        return false;
    }
}

