/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.update;

import com.sk89q.mclauncher.util.LauncherUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UninstallLog {
    private Map<String, Set<String>> entries = new HashMap<String, Set<String>>();
    private Set<String> cache = new HashSet<String>();
    private File baseDir;

    public File getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void add(String group, String entry) {
        this.cache.add(entry);
        Set<String> subentries = this.entries.get(group);
        if (subentries == null) {
            subentries = new HashSet<String>();
            this.entries.put(group, subentries);
        }
        subentries.add(entry);
    }

    public void add(File group, File entry) {
        this.add(this.relativize(group), this.relativize(entry));
    }

    public boolean has(String entry) {
        return this.cache.contains(entry);
    }

    public boolean has(File entry) {
        return this.has(this.relativize(entry));
    }

    public boolean copyGroupFrom(UninstallLog other, String group) {
        Set<String> otherSet = other.entries.get(group);
        if (otherSet == null) {
            return false;
        }
        for (String entry : otherSet) {
            this.add(group, entry);
        }
        return true;
    }

    public boolean copyGroupFrom(UninstallLog other, File entry) {
        return this.copyGroupFrom(other, this.relativize(entry));
    }

    public Set<Map.Entry<String, Set<String>>> getEntrySet() {
        return this.entries.entrySet();
    }

    public boolean hasGroup(String group) {
        return this.entries.containsKey(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(File file) throws IOException {
        this.entries = new HashMap<String, Set<String>>();
        this.cache = new HashSet<String>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || !line.contains(":")) continue;
                this.add(line.substring(0, line.indexOf(58)), line.substring(line.indexOf(58) + 1, line.length()));
            }
        }
        catch (Throwable throwable) {
            LauncherUtils.close(reader);
            throw throwable;
        }
        LauncherUtils.close(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            for (Map.Entry<String, Set<String>> entry : this.entries.entrySet()) {
                for (String subentry : entry.getValue()) {
                    writer.append(entry.getKey());
                    writer.append(":");
                    writer.append(subentry);
                    writer.newLine();
                }
            }
        }
        catch (Throwable throwable) {
            LauncherUtils.close(writer);
            throw throwable;
        }
        LauncherUtils.close(writer);
    }

    private String relativize(File child) {
        if (this.baseDir == null) {
            throw new IllegalArgumentException("base directory is not set");
        }
        URI uri = child.toURI();
        String relative = this.baseDir.toURI().relativize(uri).getPath();
        if (relative == uri.toString()) {
            throw new IllegalArgumentException("Child path not in base");
        }
        return relative;
    }
}

