/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.update;

import com.sk89q.mclauncher.model.Component;
import com.sk89q.mclauncher.util.SimpleNode;
import com.sk89q.mclauncher.util.XmlUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class UpdateCache {
    private File file;
    private String lastUpdateId;
    private Map<String, String> hashCache = new HashMap<String, String>();
    private Map<String, Boolean> componentSelection = new HashMap<String, Boolean>();
    private Set<String> touched = new HashSet<String>();

    public UpdateCache(File file) {
        this.file = file;
        try {
            this.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void read() throws IOException {
        this.hashCache = new HashMap<String, String>();
        this.touched = new HashSet<String>();
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.file));
            Document doc = XmlUtils.parseXml(in);
            XPath xpath = XPathFactory.newInstance().newXPath();
            for (Node node : XmlUtils.getNodes(doc, xpath.compile("/cache/entry"))) {
                String path = XmlUtils.getValue(node);
                String hash = XmlUtils.getAttrOrNull(node, "hash");
                this.hashCache.put(path, hash);
            }
            for (Node node : XmlUtils.getNodes(doc, xpath.compile("/cache/component"))) {
                String id = XmlUtils.getAttrOrNull(node, "id");
                String selected = XmlUtils.getAttrOrNull(node, "selected");
                if (id == null || selected == null) continue;
                this.componentSelection.put(id, selected.equalsIgnoreCase("true"));
            }
            this.lastUpdateId = XmlUtils.getStringOrNull(doc, xpath.compile("/cache/current/text()"));
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public void write() throws IOException {
        try {
            Document doc = XmlUtils.newXml();
            SimpleNode root = XmlUtils.start(doc, "cache");
            if (this.lastUpdateId != null) {
                root.addNode("current").addValue(this.lastUpdateId);
            }
            for (Map.Entry<String, String> entry : this.hashCache.entrySet()) {
                if (!this.touched.contains(entry.getKey())) continue;
                root.addNode("entry").addValue(entry.getKey()).setAttr("hash", entry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.componentSelection.entrySet()) {
                root.addNode("component").addValue(entry.getKey()).setAttr("id", entry.getKey()).setAttr("selected", (Boolean)entry.getValue() != false ? "true" : "false");
            }
            XmlUtils.writeXml(doc, this.file);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    public String getLastUpdateId() {
        return this.lastUpdateId;
    }

    public void setLastUpdateId(String lastUpdateId) {
        this.lastUpdateId = lastUpdateId;
    }

    public String getFileVersion(String path) {
        return this.hashCache.get(path);
    }

    public void setFileVersion(String path, String hash) {
        if (hash == null) {
            this.hashCache.remove(path);
        } else {
            this.touch(path);
            this.hashCache.put(path, hash);
        }
    }

    public void touch(String cacheId) {
        this.touched.add(cacheId);
    }

    public void storeSelection(Component component) {
        this.componentSelection.put(component.getId(), component.isSelected());
    }

    public void recallSelection(Component component) {
        Boolean value = this.componentSelection.get(component.getId());
        if (value != null) {
            component.setSelected(value);
        }
    }
}

