/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.update;

import com.sk89q.mclauncher.model.UpdateManifest;
import com.sk89q.mclauncher.util.XmlUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;

public class UpdateManifestFetcher {
    private static final Logger logger = Logger.getLogger(UpdateManifestFetcher.class.getCanonicalName());
    private URL updateUrl;
    private UpdateManifest manifest;

    public UpdateManifestFetcher(URL updateUrl) {
        this.updateUrl = updateUrl;
    }

    public void downloadManifest() throws IOException {
        if (this.manifest != null) {
            return;
        }
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)this.updateUrl.openConnection();
            conn.setRequestMethod("GET");
            conn.setUseCaches(false);
            conn.setDoInput(true);
            conn.setDoOutput(false);
            conn.setReadTimeout(5000);
            conn.connect();
            if (conn.getResponseCode() != 200) {
                throw new IOException("Did not get expected 200 code");
            }
            this.manifest = XmlUtils.parseJaxb(UpdateManifest.class, new BufferedInputStream(conn.getInputStream()));
        }
        catch (JAXBException e) {
            logger.log(Level.WARNING, "Failed to read update manifest", e);
            throw new IOException("Failed to parse update manifest", e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
            conn = null;
        }
    }

    public URL getUpdateURL() {
        return this.updateUrl;
    }

    public UpdateManifest getManifest() {
        return this.manifest;
    }
}

