/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.update;

import com.sk89q.mclauncher.Launcher;
import com.sk89q.mclauncher.config.Configuration;
import com.sk89q.mclauncher.model.PackageManifest;
import com.sk89q.mclauncher.session.LoginSession;
import com.sk89q.mclauncher.session.MinecraftSession;
import com.sk89q.mclauncher.update.PackageManifestUpdater;
import com.sk89q.mclauncher.update.UpdateCache;
import com.sk89q.mclauncher.update.UpdateCheck;
import com.sk89q.mclauncher.update.UpdateException;
import com.sk89q.mclauncher.update.Updater;
import com.sk89q.mclauncher.util.LauncherUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VanillaUpdateCheck
implements UpdateCheck {
    private static final URL BASE_URL = LauncherUtils.createURL("http://minecraft.net");
    private static final Logger logger = Logger.getLogger(VanillaUpdateCheck.class.getCanonicalName());
    private final Configuration configuration;
    private final UpdateCache cache;
    private final LoginSession session;

    public VanillaUpdateCheck(Configuration configuration, LoginSession session, UpdateCache cache) {
        this.configuration = configuration;
        this.session = session;
        this.cache = cache;
    }

    @Override
    public boolean needsUpdate() {
        if (this.cache.getLastUpdateId() == null) {
            try {
                this.importLauncherUpdateVersion(this.cache);
                this.cache.write();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to import version information from official launcher", e);
            }
        }
        return !this.session.getLatestVersion().equals(this.cache.getLastUpdateId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Updater createUpdater() throws UpdateException {
        PackageManifest manifest;
        InputStream is = null;
        try {
            is = Launcher.class.getResourceAsStream("/resources/update.xml");
            if (is == null) {
                throw new UpdateException("Failed to get embedded update.xml required to update vanilla Minecraft. (Re-download launcher?)");
            }
            manifest = PackageManifestUpdater.parsePackage(is);
        }
        finally {
            LauncherUtils.close(is);
        }
        return new PackageManifestUpdater(BASE_URL, manifest, this.configuration.getMinecraftDir(), this.cache, this.session.getLatestVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importLauncherUpdateVersion(UpdateCache cache) throws IOException {
        File file = new File(Launcher.getOfficialDataDir(), "bin/version");
        if (!file.exists()) {
            return;
        }
        DataInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(file));
            String version = in.readUTF();
            cache.setLastUpdateId(version);
        }
        catch (Throwable throwable) {
            LauncherUtils.close(in);
            throw throwable;
        }
        LauncherUtils.close(in);
    }

    public static UpdateCheck fromSession(Configuration configuration, MinecraftSession session, UpdateCache cache) throws UpdateException {
        if (!(session instanceof LoginSession)) {
            throw new UpdateException("An update is not possible when in offline mode.");
        }
        return new VanillaUpdateCheck(configuration, (LoginSession)session, cache);
    }
}

