/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.util;

import com.sk89q.mclauncher.event.DownloadListener;
import com.sk89q.mclauncher.event.DownloadProgressEvent;
import com.sk89q.mclauncher.util.Downloader;
import java.io.OutputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.util.EventObject;
import javax.swing.event.EventListenerList;

public abstract class AbstractDownloader
implements Downloader {
    private int timeout = 300000;
    private OutputStream output;
    private URL url;
    private volatile boolean running = true;
    private String etagCheck = null;
    private MessageDigest digest;
    private EventListenerList listenerList = new EventListenerList();

    public AbstractDownloader(URL url, OutputStream output) {
        this.url = url;
        this.output = output;
    }

    @Override
    public void addDownloadListener(DownloadListener l) {
        this.listenerList.add(DownloadListener.class, l);
    }

    @Override
    public void removeDownloadListener(DownloadListener l) {
        this.listenerList.remove(DownloadListener.class, l);
    }

    protected void fireConnectionStarted() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((DownloadListener)listeners[i + 1]).connectionStarted(new EventObject(this));
        }
    }

    protected void fireLengthKnown() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((DownloadListener)listeners[i + 1]).lengthKnown(new EventObject(this));
        }
    }

    protected void fireDownloadProgress(long downloaded) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((DownloadListener)listeners[i + 1]).downloadProgress(new DownloadProgressEvent(this, downloaded));
        }
    }

    protected void fireDownloadCompleted() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((DownloadListener)listeners[i + 1]).downloadCompleted(new EventObject(this));
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public OutputStream getOutput() {
        return this.output;
    }

    public void setOutput(OutputStream output) {
        this.output = output;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public MessageDigest getDigest() {
        return this.digest;
    }

    public void setDigest(MessageDigest digest) {
        this.digest = digest;
    }

    public EventListenerList getListenerList() {
        return this.listenerList;
    }

    public void setListenerList(EventListenerList listenerList) {
        this.listenerList = listenerList;
    }

    public String getEtagCheck() {
        return this.etagCheck;
    }

    @Override
    public void setEtagCheck(String etag) {
        this.etagCheck = etag;
    }

    @Override
    public void setMessageDigest(MessageDigest digest) {
        this.digest = digest;
    }

    @Override
    public void cancel() {
        this.running = false;
    }

    protected class ProgressEventUpdater
    implements Runnable {
        private volatile boolean running = true;

        protected ProgressEventUpdater() {
        }

        @Override
        public void run() {
            while (this.running) {
                AbstractDownloader.this.fireDownloadProgress(AbstractDownloader.this.getDownloadedLength());
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }

        public void stop() {
            this.running = false;
        }
    }
}

