/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BasicArgsParser {
    private Set<String> flagArgs = new HashSet<String>();
    private Set<String> valueArgs = new HashSet<String>();

    public void addFlagArg(String arg) {
        this.flagArgs.add(arg);
    }

    public void addValueArg(String arg) {
        this.valueArgs.add(arg);
    }

    public ArgsContext parse(String[] args) {
        ArrayList<String> leftOver = new ArrayList<String>();
        HashSet<String> flags = new HashSet<String>();
        HashMap<String, String> values = new HashMap<String, String>();
        String wantingFlag = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-")) {
                if (arg.length() == 1) {
                    throw new IllegalArgumentException("Flag with no name");
                }
                String flag = arg.substring(1);
                if (this.valueArgs.contains(flag)) {
                    wantingFlag = flag;
                    continue;
                }
                if (this.flagArgs.contains(flag)) {
                    flags.add(flag);
                    continue;
                }
                throw new IllegalArgumentException("Unknown flag " + flag);
            }
            if (wantingFlag != null) {
                values.put(wantingFlag, arg);
                wantingFlag = null;
                continue;
            }
            leftOver.add(arg);
        }
        return new ArgsContext(flags, values, leftOver);
    }

    public static class ArgsContext {
        private List<String> args;
        private Set<String> flags;
        private Map<String, String> values;

        private ArgsContext(Set<String> flags, Map<String, String> values, List<String> args) {
            this.args = args;
            this.flags = flags;
            this.values = values;
        }

        public List<String> getArgs() {
            return this.args;
        }

        public Set<String> getFlags() {
            return this.flags;
        }

        public boolean has(String flag) {
            return this.flags.contains(flag);
        }

        public Map<String, String> getValues() {
            return this.values;
        }

        public String get(int i) {
            return this.args.get(i);
        }

        public String get(String flag) {
            return this.values.get(flag);
        }

        public boolean getBool(String flag, boolean def) {
            String val = this.get(flag);
            if (val == null) {
                return def;
            }
            return val == "true";
        }

        public int getInt(String flag, int def) {
            String val = this.get(flag);
            if (val == null) {
                return def;
            }
            try {
                return Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                return def;
            }
        }

        public int length() {
            return this.args.size();
        }
    }
}

