/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.util;

import com.sk89q.mclauncher.util.MessageLog;
import com.sk89q.mclauncher.util.PastebinPoster;
import com.sk89q.mclauncher.util.SwingHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;

public class ConsoleFrame
extends JFrame
implements PastebinPoster.PasteCallback {
    private static final long serialVersionUID = -3266712569265372777L;
    protected final ConsoleFrame self = this;
    protected boolean running = true;
    protected final MessageLog messageLog;
    protected Box buttonsPanel;

    public ConsoleFrame(int numLines, boolean colorEnabled) {
        this("Console", numLines, colorEnabled);
    }

    public ConsoleFrame(String title, int numLines, boolean colorEnabled) {
        super(title);
        SwingHelper.setIconImage(this, "/resources/tray_ok.png");
        this.messageLog = new MessageLog(numLines, colorEnabled);
        this.setSize(new Dimension(650, 400));
        this.addComponents();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                ConsoleFrame.this.tryClose();
            }
        });
    }

    public boolean isRunning() {
        return this.running;
    }

    public MessageLog getMessageLog() {
        return this.messageLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryClose() {
        ConsoleFrame consoleFrame = this.self;
        synchronized (consoleFrame) {
            if (!this.running) {
                return;
            }
            this.running = false;
            this.self.notifyAll();
        }
        this.messageLog.detachGlobalHandler();
        this.dispose();
    }

    protected void addComponents() {
        this.buttonsPanel = Box.createHorizontalBox();
        this.buttonsPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JButton pastebinButton = new JButton("Upload Log...");
        this.buttonsPanel.add(pastebinButton);
        this.buttonsPanel.add(Box.createHorizontalStrut(5));
        this.add((Component)this.buttonsPanel, "North");
        pastebinButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = ConsoleFrame.this.messageLog.getPastableText();
                ConsoleFrame.this.messageLog.log("Uploading paste (" + text.length() + " bytes)...\n", ConsoleFrame.this.messageLog.asHighlighted());
                PastebinPoster.paste(text, ConsoleFrame.this.self);
            }
        });
        this.add((Component)this.messageLog, "Center");
    }

    @Override
    public void handleSuccess(String url) {
        this.messageLog.log("Paste uploaded to: " + url + "\n", this.messageLog.asHighlighted());
        SwingHelper.openURL(url, (Component)this);
    }

    @Override
    public void handleError(String err) {
        this.messageLog.log("Failed to upload paste: " + err + "\n", this.messageLog.asError());
    }

    public void log(String line) {
        this.messageLog.log(line, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor() {
        while (this.running) {
            try {
                ConsoleFrame consoleFrame = this;
                synchronized (consoleFrame) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }
}

