/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.util;

import com.sk89q.mclauncher.Launcher;
import com.sk89q.mclauncher.util.ConsoleFrame;
import com.sk89q.mclauncher.util.SwingHelper;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class GameConsoleFrame
extends ConsoleFrame {
    private static final long serialVersionUID = -737598535474470253L;
    private static final Image trayOkImage = SwingHelper.readIconImage("/resources/tray_ok.png");
    private static final Image trayClosedImage = SwingHelper.readIconImage("/resources/tray_closed.png");
    private JButton killButton;
    private JButton minimizeButton;
    private TrayIcon trayIcon;
    private Process trackProc;
    private boolean killProcess;

    public GameConsoleFrame(int numLines, boolean colorEnabled, Process proc, boolean killProcess) {
        super("Messages and Errors", numLines, colorEnabled);
        this.trackProc = proc;
        this.killProcess = killProcess;
        if (proc != null) {
            this.track(proc);
        }
    }

    @Override
    protected void tryClose() {
        if (this.killProcess && this.trackProc != null) {
            if (!this.confirmKill()) {
                return;
            }
            this.trackProc.destroy();
            this.trackProc = null;
        }
        if (this.trackProc == null || this.trayIcon == null) {
            if (this.trayIcon != null) {
                SystemTray.getSystemTray().remove(this.trayIcon);
            }
            super.tryClose();
        } else {
            this.minimize();
        }
    }

    private boolean confirmKill() {
        boolean confirmKill = Launcher.getInstance().getOptions().getSettings().getBool("console.confirm-kill", true);
        return !confirmKill || JOptionPane.showConfirmDialog(this, "Are you sure? If you're in a single player game, this can make you lose your progress!", "Force Close", 0) == 0;
    }

    private void tryKill() {
        if (!this.confirmKill()) {
            return;
        }
        if (this.killButton != null) {
            this.killButton.setEnabled(false);
        }
        if (this.trackProc != null) {
            this.trackProc.destroy();
            this.trackProc = null;
        }
        this.messageLog.detachGlobalHandler();
    }

    private void minimize() {
        this.setVisible(false);
    }

    private void reshow() {
        this.self.setVisible(true);
        this.self.requestFocus();
    }

    @Override
    protected void addComponents() {
        super.addComponents();
        this.killButton = new JButton("Force Close");
        this.minimizeButton = new JButton("Hide Window");
        this.buttonsPanel.add(Box.createHorizontalGlue());
        this.buttonsPanel.add(this.killButton);
        this.buttonsPanel.add(Box.createHorizontalStrut(5));
        this.buttonsPanel.add(this.minimizeButton);
        this.killButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GameConsoleFrame.this.tryKill();
            }
        });
        this.minimizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GameConsoleFrame.this.minimize();
            }
        });
        if (!this.setupTrayIcon()) {
            this.minimizeButton.setEnabled(true);
        }
    }

    private boolean setupTrayIcon() {
        if (!SystemTray.isSupported() || trayOkImage == null || trayClosedImage == null) {
            return false;
        }
        this.trayIcon = new TrayIcon(trayOkImage);
        this.trayIcon.setImageAutoSize(true);
        this.trayIcon.setToolTip("Messages and Errors for SKMCLauncher");
        this.trayIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GameConsoleFrame.this.reshow();
            }
        });
        PopupMenu popup = new PopupMenu();
        MenuItem item = new MenuItem("SKMCLauncher");
        popup.add(item);
        item.setEnabled(false);
        item = new MenuItem("Show messages and errors");
        popup.add(item);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GameConsoleFrame.this.reshow();
            }
        });
        item = new MenuItem("Kill game");
        popup.add(item);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GameConsoleFrame.this.tryKill();
            }
        });
        this.trayIcon.setPopupMenu(popup);
        try {
            SystemTray tray = SystemTray.getSystemTray();
            tray.add(this.trayIcon);
            return true;
        }
        catch (AWTException aWTException) {
            return false;
        }
    }

    private void track(Process process) {
        PrintWriter out = new PrintWriter(this.messageLog.getOutputStream(Color.MAGENTA), true);
        Thread thread = new Thread(new ProcessTracker(out));
        thread.setName("Console Game Process Tracker");
        thread.setDaemon(true);
        thread.start();
    }

    private class ProcessTracker
    implements Runnable {
        private final PrintWriter out;

        public ProcessTracker(PrintWriter out) {
            this.out = out;
        }

        @Override
        public void run() {
            try {
                int code = GameConsoleFrame.this.trackProc.waitFor();
                this.out.println("Process ended with code " + code);
                this.out.println("Minecraft is no longer running! Click 'Close Window' to close this window.");
                this.out.println("Did you know: In 'Options', under 'Environment', you can disable this window from appearing.");
                GameConsoleFrame.this.trackProc = null;
            }
            catch (InterruptedException e) {
                this.out.println("Process tracking interrupted!");
            }
            if (!GameConsoleFrame.this.running) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (GameConsoleFrame.this.killButton != null) {
                        GameConsoleFrame.this.killButton.setEnabled(false);
                    }
                    if (GameConsoleFrame.this.minimizeButton != null) {
                        GameConsoleFrame.this.minimizeButton.setText("Close Window");
                        GameConsoleFrame.this.minimizeButton.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                GameConsoleFrame.this.tryClose();
                            }
                        });
                    }
                    if (GameConsoleFrame.this.trayIcon != null) {
                        GameConsoleFrame.this.trayIcon.setImage(trayClosedImage);
                    }
                    SwingHelper.setIconImage(GameConsoleFrame.this.self, "/resources/tray_closed.png");
                    GameConsoleFrame.this.reshow();
                }
            });
        }
    }
}

