/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.util;

import com.sk89q.mclauncher.Launcher;
import com.sk89q.mclauncher.util.Platform;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import util.WinRegistry;

public final class JavaRuntimeFinder {
    private JavaRuntimeFinder() {
    }

    public static File findBestJavaPath() {
        if (Launcher.getPlatform() != Platform.WINDOWS) {
            return null;
        }
        ArrayList<JREEntry> entries = new ArrayList<JREEntry>();
        try {
            JavaRuntimeFinder.getEntriesFromRegistry(entries, "SOFTWARE\\JavaSoft\\Java Runtime Environment");
            JavaRuntimeFinder.getEntriesFromRegistry(entries, "SOFTWARE\\JavaSoft\\Java Development Kit");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Collections.sort(entries);
        if (entries.size() > 0) {
            return new File(((JREEntry)entries.get(0)).dir, "bin");
        }
        return null;
    }

    private static void getEntriesFromRegistry(List<JREEntry> entries, String basePath) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        List<String> subKeys = WinRegistry.readStringSubKeys(-2147483646, basePath);
        for (String subKey : subKeys) {
            JREEntry entry = JavaRuntimeFinder.getEntryFromRegistry(basePath, subKey);
            if (entry == null) continue;
            entries.add(entry);
        }
    }

    private static JREEntry getEntryFromRegistry(String basePath, String version) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String regPath = basePath + "\\" + version;
        String path = WinRegistry.readString(-2147483646, regPath, "JavaHome");
        File dir = new File(path);
        if (dir.exists() && new File(dir, "bin/java.exe").exists()) {
            JREEntry entry = new JREEntry();
            entry.dir = dir;
            entry.version = version;
            entry.is64Bit = JavaRuntimeFinder.guessIf64Bit(dir);
            return entry;
        }
        return null;
    }

    private static boolean guessIf64Bit(File path) {
        String programFilesX86 = System.getenv("ProgramFiles(x86)");
        if (programFilesX86 == null) {
            return true;
        }
        return !path.toString().startsWith(new File(programFilesX86).toString());
    }

    private static class JREEntry
    implements Comparable<JREEntry> {
        private File dir;
        private String version;
        private boolean is64Bit;

        private JREEntry() {
        }

        @Override
        public int compareTo(JREEntry o) {
            if (this.is64Bit && !o.is64Bit) {
                return -1;
            }
            if (!this.is64Bit && o.is64Bit) {
                return 1;
            }
            String[] a = this.version.split("[\\._]");
            String[] b = o.version.split("[\\._]");
            int min = Math.min(a.length, b.length);
            for (int i = 0; i < min; ++i) {
                int second;
                int first;
                try {
                    first = Integer.parseInt(a[i]);
                }
                catch (NumberFormatException e) {
                    return -1;
                }
                try {
                    second = Integer.parseInt(b[i]);
                }
                catch (NumberFormatException e) {
                    return 1;
                }
                if (first > second) {
                    return -1;
                }
                if (first >= second) continue;
                return 1;
            }
            if (a.length == b.length) {
                return 0;
            }
            return a.length > b.length ? -1 : 1;
        }
    }
}

