/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;

public final class LauncherUtils {
    private static final Pattern absoluteUrlPattern = Pattern.compile("^[A-Za-z0-9\\-]+://.*$");

    private LauncherUtils() {
    }

    public static void close(Closeable o) {
        if (o == null) {
            return;
        }
        try {
            o.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static <T extends Enum<T>> T valueOf(Class<T> en, String name) {
        if (name == null) {
            return null;
        }
        try {
            return Enum.valueOf(en, name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static <T extends Enum<T>> T uppercaseValueOf(Class<T> en, String name) {
        if (name == null) {
            return null;
        }
        return LauncherUtils.valueOf(en, name.toUpperCase());
    }

    public static <T> T defaultValue(T obj, T def) {
        return obj != null ? obj : def;
    }

    public static String nullEmpty(String s) {
        if (s == null) {
            return null;
        }
        if (s.trim().length() == 0) {
            return null;
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File from, File to) throws IOException {
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            int len;
            in = new BufferedInputStream(new FileInputStream(from));
            out = new BufferedOutputStream(new FileOutputStream(to));
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
        catch (Throwable throwable) {
            LauncherUtils.close(in);
            LauncherUtils.close(out);
            throw throwable;
        }
        LauncherUtils.close(in);
        LauncherUtils.close(out);
    }

    public static String getExtension(String name) {
        int index = name.lastIndexOf(46);
        if (index == 0) {
            return "";
        }
        return name.substring(index + 1, name.length());
    }

    public static String getExtension(File file) {
        return LauncherUtils.getExtension(file.getName());
    }

    public static String getStackTrace(Throwable t) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        t.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    public static void consumeBlindly(InputStream from) {
        final InputStream in = from;
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                byte[] buffer = new byte[1024];
                try {
                    while (in.read(buffer) != -1) {
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    LauncherUtils.close(in);
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public static File getClosestDirectory(String path) {
        if (path == null) {
            return null;
        }
        File f = new File(path);
        while (!f.isDirectory()) {
            File parent = f.getParentFile();
            if (parent == null) {
                return null;
            }
            f = parent;
        }
        return f;
    }

    public static String getMCVersion(File file) {
        String prefix = "Minecraft Minecraft ";
        Pattern magic = Pattern.compile("(" + prefix + "(\\w|\\.|\\s|\\p{Punct})+(?=\u0001\u0000))");
        String version = "Unknown";
        try {
            JarFile jar = new JarFile(file);
            ZipEntry entry = jar.getEntry("net/minecraft/client/Minecraft.class");
            if (entry != null) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(jar.getInputStream(entry)));
                while ((line = br.readLine()) != null) {
                    Matcher matcher = magic.matcher(line);
                    if (!matcher.find()) continue;
                    version = matcher.group().substring(prefix.length());
                    break;
                }
                br.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return version;
    }

    public static URL concat(URL baseUrl, String url) throws MalformedURLException {
        if (absoluteUrlPattern.matcher(url).matches()) {
            return new URL(url);
        }
        int lastSlash = baseUrl.toExternalForm().lastIndexOf("/");
        if (lastSlash == -1) {
            return new URL(url);
        }
        int firstSlash = url.indexOf("/");
        if (firstSlash == 0) {
            boolean portSet = baseUrl.getDefaultPort() == baseUrl.getPort() || baseUrl.getPort() == -1;
            String port = portSet ? "" : ":" + baseUrl.getPort();
            return new URL(baseUrl.getProtocol() + "://" + baseUrl.getHost() + port + url);
        }
        return new URL(baseUrl.toExternalForm().substring(0, lastSlash + 1) + url);
    }

    public static String getDigestAsHex(String str, String algorithm) {
        Closeable fis = null;
        try {
            MessageDigest complete = MessageDigest.getInstance(algorithm);
            complete.update(str.getBytes());
            String string = LauncherUtils.getHexString(complete.digest());
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        finally {
            LauncherUtils.close(fis);
        }
    }

    public static String getHexString(byte[] b) {
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    public static void cleanDir(File dir) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!dir.exists()) {
            return;
        }
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                LauncherUtils.cleanDir(f);
                f.delete();
                continue;
            }
            f.delete();
        }
    }

    public static URL createURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static void checkInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public static String getRelative(File base, File path) {
        return base.toURI().relativize(path.toURI()).getPath();
    }

    public static String joinUnixPath(String path, String path2) {
        if (!path.isEmpty()) {
            return path + "/" + path2;
        }
        return path2;
    }
}

