/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.util;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class LinkButton
extends JButton {
    private static final long serialVersionUID = 8415038817435411359L;
    private static final Color LINK_COLOR = Color.blue;
    private static final Border LINK_BORDER = BorderFactory.createEmptyBorder(0, 0, 1, 0);
    private static final Border HOVER_BORDER = BorderFactory.createMatteBorder(0, 0, 1, 0, LINK_COLOR);

    public LinkButton() {
        this.setupLink();
    }

    public LinkButton(Action a) {
        super(a);
        this.setupLink();
    }

    public LinkButton(Icon icon) {
        super(icon);
        this.setupLink();
    }

    public LinkButton(String text, Icon icon) {
        super(text, icon);
        this.setupLink();
    }

    public LinkButton(String text) {
        super(text);
        this.setupLink();
    }

    public void setupLink() {
        this.setBorder(LINK_BORDER);
        this.setForeground(LINK_COLOR);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setFocusPainted(false);
        this.setRequestFocusEnabled(false);
        this.setContentAreaFilled(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ((JComponent)e.getComponent()).setBorder(HOVER_BORDER);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ((JComponent)e.getComponent()).setBorder(LINK_BORDER);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ((JComponent)e.getComponent()).setBorder(LINK_BORDER);
            }
        });
    }
}

