/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.util;

import com.sk89q.mclauncher.util.LauncherUtils;
import com.sk89q.mclauncher.util.LimitLinesDocumentListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class MessageLog
extends JPanel {
    private static final Logger rootLogger = Logger.getLogger("");
    private static final long serialVersionUID = -1470963240447538893L;
    private final int numLines;
    private final boolean colorEnabled;
    protected JTextComponent textComponent;
    protected Document document;
    private Handler loggerHandler;
    protected final SimpleAttributeSet defaultAttributes = new SimpleAttributeSet();
    protected final SimpleAttributeSet highlightedAttributes;
    protected final SimpleAttributeSet errorAttributes;
    protected final SimpleAttributeSet infoAttributes;
    protected final SimpleAttributeSet debugAttributes;

    public MessageLog(int numLines, boolean colorEnabled) {
        this.numLines = numLines;
        this.colorEnabled = colorEnabled;
        this.highlightedAttributes = new SimpleAttributeSet();
        StyleConstants.setForeground(this.highlightedAttributes, Color.BLACK);
        StyleConstants.setBackground(this.highlightedAttributes, Color.YELLOW);
        this.errorAttributes = new SimpleAttributeSet();
        StyleConstants.setForeground(this.errorAttributes, new Color(200, 0, 0));
        this.infoAttributes = new SimpleAttributeSet();
        StyleConstants.setForeground(this.infoAttributes, new Color(200, 0, 0));
        this.debugAttributes = new SimpleAttributeSet();
        StyleConstants.setForeground(this.debugAttributes, Color.DARK_GRAY);
        this.setLayout(new BorderLayout());
        this.addComponents();
    }

    private void addComponents() {
        JTextComponent text;
        if (this.colorEnabled) {
            this.textComponent = text = new JTextPane(){
                private static final long serialVersionUID = 6814733823000144811L;

                @Override
                public boolean getScrollableTracksViewportWidth() {
                    return true;
                }
            };
        } else {
            this.textComponent = text = new JTextArea();
            ((JTextArea)text).setLineWrap(true);
            ((JTextArea)text).setWrapStyleWord(true);
        }
        this.textComponent.setFont(new JLabel().getFont());
        this.textComponent.setEditable(false);
        DefaultCaret caret = (DefaultCaret)this.textComponent.getCaret();
        caret.setUpdatePolicy(1);
        this.document = this.textComponent.getDocument();
        this.document.addDocumentListener(new LimitLinesDocumentListener(this.numLines, true));
        JScrollPane scrollText = new JScrollPane(this.textComponent);
        scrollText.setBorder(null);
        scrollText.setVerticalScrollBarPolicy(22);
        scrollText.setHorizontalScrollBarPolicy(31);
        this.add((Component)scrollText, "Center");
    }

    public String getPastableText() {
        String text = this.textComponent.getText().replaceAll("[\r\n]+", "\n");
        text = text.replaceAll("Session ID is [A-Fa-f0-9]+", "Session ID is [redacted]");
        return text;
    }

    public void clear() {
        this.textComponent.setText("");
    }

    public void log(String line, AttributeSet attributes) {
        if (this.colorEnabled && line.startsWith("(!!)")) {
            attributes = this.highlightedAttributes;
        }
        try {
            int offset = this.document.getLength();
            this.document.insertString(offset, line, attributes != null && this.colorEnabled ? attributes : this.defaultAttributes);
            this.textComponent.setCaretPosition(this.document.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public ConsoleOutputStream getOutputStream() {
        return this.getOutputStream((AttributeSet)null);
    }

    public ConsoleOutputStream getOutputStream(AttributeSet attributes) {
        return new ConsoleOutputStream(attributes);
    }

    public ConsoleOutputStream getOutputStream(Color color) {
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setForeground(attributes, color);
        return this.getOutputStream(attributes);
    }

    public void consume(InputStream from) {
        this.consume(from, this.getOutputStream());
    }

    public void consume(InputStream from, Color color) {
        this.consume(from, this.getOutputStream(color));
    }

    public void consume(InputStream from, AttributeSet attributes) {
        this.consume(from, this.getOutputStream(attributes));
    }

    private void consume(InputStream from, ConsoleOutputStream outputStream) {
        final InputStream in = from;
        final PrintWriter out = new PrintWriter(outputStream, true);
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                byte[] buffer = new byte[1024];
                try {
                    int len;
                    while ((len = in.read(buffer)) != -1) {
                        String s = new String(buffer, 0, len);
                        System.out.print(s);
                        out.append(s);
                        out.flush();
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    LauncherUtils.close(in);
                    LauncherUtils.close(out);
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public void registerLoggerHandler() {
        this.loggerHandler = new ConsoleLoggerHandler();
        rootLogger.addHandler(this.loggerHandler);
    }

    public void detachGlobalHandler() {
        if (this.loggerHandler != null) {
            rootLogger.removeHandler(this.loggerHandler);
            this.loggerHandler = null;
        }
    }

    public SimpleAttributeSet asDefault() {
        return this.defaultAttributes;
    }

    public SimpleAttributeSet asHighlighted() {
        return this.highlightedAttributes;
    }

    public SimpleAttributeSet asError() {
        return this.errorAttributes;
    }

    public SimpleAttributeSet asInfo() {
        return this.infoAttributes;
    }

    public SimpleAttributeSet asDebug() {
        return this.debugAttributes;
    }

    private class ConsoleOutputStream
    extends ByteArrayOutputStream {
        private AttributeSet attributes;

        private ConsoleOutputStream(AttributeSet attributes) {
            this.attributes = attributes;
        }

        @Override
        public void flush() {
            String data = this.toString();
            if (data.length() == 0) {
                return;
            }
            MessageLog.this.log(data, this.attributes);
            this.reset();
        }
    }

    private class ConsoleLoggerHandler
    extends Handler {
        private ConsoleLoggerHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            Level level = record.getLevel();
            Throwable t = record.getThrown();
            SimpleAttributeSet attributes = MessageLog.this.defaultAttributes;
            if (level.intValue() >= Level.WARNING.intValue()) {
                attributes = MessageLog.this.errorAttributes;
            } else if (level.intValue() < Level.INFO.intValue()) {
                attributes = MessageLog.this.debugAttributes;
            }
            MessageLog.this.log(record.getMessage() + "\n", attributes);
            if (t != null) {
                MessageLog.this.log(LauncherUtils.getStackTrace(t) + "\n", attributes);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

