/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class MixedDataBufferedInputStream
extends BufferedInputStream {
    private int lineBufferSize = 8192;

    public MixedDataBufferedInputStream(InputStream in) {
        super(in);
    }

    public MixedDataBufferedInputStream(InputStream in, int lineBufferSize) {
        super(in);
        this.lineBufferSize = lineBufferSize;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String readLine() throws IOException {
        byte[] buf = new byte[this.lineBufferSize];
        int pos = 0;
        boolean foundCR = false;
        while (true) {
            int ch;
            if ((ch = this.read()) == 13) {
                buf[pos++] = (byte)ch;
                foundCR = true;
                this.in.mark(1);
                continue;
            }
            if (ch == 10 || ch < 0) {
                buf[pos++] = (byte)ch;
                return new String(Arrays.copyOf(buf, pos), "UTF-8");
            }
            if (foundCR) {
                this.in.reset();
                return new String(Arrays.copyOf(buf, pos), "UTF-8");
            }
            buf[pos++] = (byte)ch;
            if (pos == buf.length) return new String(Arrays.copyOf(buf, pos), "UTF-8");
        }
    }
}

