/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class SimpleLogFormatter
extends Formatter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(record.getLevel().getLocalizedName()).append("] ").append(this.formatMessage(record)).append(LINE_SEPARATOR);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    public static void setAsFormatter() {
        for (Handler handler : Logger.getLogger("").getHandlers()) {
            handler.setFormatter(new SimpleLogFormatter());
        }
    }
}

