/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.util;

import com.sk89q.mclauncher.Launcher;
import com.sk89q.mclauncher.util.LauncherUtils;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public final class SwingHelper {
    private static String[] monospaceFontNames = new String[]{"Consolas", "DejaVu Sans Mono", "Bitstream Vera Sans Mono", "Lucida Console"};
    private static boolean confirmResult;

    private SwingHelper() {
    }

    public static void browseDir(File file, Component component) {
        try {
            Desktop.getDesktop().browse(new URL("file://" + file.getAbsolutePath()).toURI());
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(component, "Unable to open '" + file.getAbsolutePath() + "'. Maybe it doesn't exist?", "Open failed", 0);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public static void openURL(String url, Component component) {
        try {
            SwingHelper.openURL(new URL(url), component);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public static void openURL(URL url, Component component) {
        try {
            Desktop.getDesktop().browse(url.toURI());
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(component, "Unable to open '" + url + "'", "Open failed", 0);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public static void showError(final Component component, final String title, final String message) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SwingHelper.showError(component, title, message);
                    }
                });
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        String newMessage = message.replace(">", "&gt;").replace("<", "&lt;").replace("&", "&amp;");
        newMessage = "<html>" + newMessage;
        JOptionPane.showMessageDialog(component, newMessage, title, 0);
    }

    public static boolean confirm(final Component component, final String title, final String message) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        confirmResult = SwingHelper.confirm(component, title, message);
                    }
                });
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            return confirmResult;
        }
        return JOptionPane.showConfirmDialog(component, message, title, 0) == 0;
    }

    public static void equalWidth(Component ... component) {
        Dimension dim;
        double widest = 0.0;
        for (Component comp : component) {
            dim = comp.getPreferredSize();
            if (!(dim.getWidth() > widest)) continue;
            widest = dim.getWidth();
        }
        for (Component comp : component) {
            dim = comp.getPreferredSize();
            comp.setPreferredSize(new Dimension((int)widest, (int)dim.getHeight()));
        }
    }

    public static void removeOpaqueness(Component ... components) {
        for (Component component : components) {
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.setOpaque(false);
            SwingHelper.removeOpaqueness(jComponent.getComponents());
        }
    }

    public static Font getMonospaceFont() {
        for (String fontName : monospaceFontNames) {
            Font font = Font.decode(fontName + "-11");
            if (font.getFamily().equalsIgnoreCase("Dialog")) continue;
            return font;
        }
        return new Font("Monospace", 0, 11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readIconImage(String path) {
        InputStream in = null;
        try {
            in = Launcher.class.getResourceAsStream(path);
            if (in != null) {
                BufferedImage bufferedImage = ImageIO.read(in);
                return bufferedImage;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            LauncherUtils.close(in);
        }
        return null;
    }

    public static void setIconImage(JFrame frame, String path) {
        BufferedImage image = SwingHelper.readIconImage(path);
        if (image != null) {
            frame.setIconImage(image);
        }
    }

    public static void setLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void focusLater(final Component component) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (component instanceof JTextComponent) {
                    ((JTextComponent)component).selectAll();
                }
                component.requestFocusInWindow();
            }
        });
    }

    public static void invokeAndWait(Runnable runnable) {
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

