/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher.util;

import com.sk89q.mclauncher.Launcher;
import com.sk89q.mclauncher.ProgressDialog;
import com.sk89q.mclauncher.event.ProgressListener;
import com.sk89q.mclauncher.event.StatusChangeEvent;
import com.sk89q.mclauncher.event.TitleChangeEvent;
import com.sk89q.mclauncher.event.ValueChangeEvent;
import com.sk89q.mclauncher.util.SwingHelper;
import com.sk89q.mclauncher.util.TaskWorker;
import java.awt.Component;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public abstract class Task
implements Runnable {
    private static final Logger logger = Logger.getLogger(Task.class.getCanonicalName());
    private Component component;
    private EventListenerList listenerList = new EventListenerList();
    private Thread thread;
    private double subprogressOffset = 0.0;
    private double subprogressSize = 1.0;

    public String getInitialTitle() {
        return "Working...";
    }

    public Component getComponent() {
        return this.component;
    }

    private void setComponent(Component component) {
        this.component = component;
    }

    public ProgressListener[] getProgressListenerList() {
        return (ProgressListener[])this.listenerList.getListeners(ProgressListener.class);
    }

    public void addProgressListener(ProgressListener l) {
        this.listenerList.add(ProgressListener.class, l);
    }

    public void removeProgressListener(ProgressListener l) {
        this.listenerList.remove(ProgressListener.class, l);
    }

    @Override
    public final void run() {
        try {
            this.thread = Thread.currentThread();
            this.execute();
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SwingHelper.showError(Task.this.component, "Error occurred", e.getMessage());
                    }
                });
            }
            catch (InterruptedException e1) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        catch (Throwable t) {
            Launcher.showConsole();
            logger.log(Level.SEVERE, "Unexpected error occurred (please report this error in full)", t);
            SwingHelper.showError(this.component, "Error occurred", "An unexpected error has occurred. Please report the error shown in the newly-shown console.");
        }
        this.fireComplete();
    }

    protected abstract void execute() throws ExecutionException, InterruptedException;

    public final boolean cancel() {
        if (this.tryCancel()) {
            Thread thread = this.thread;
            if (thread != null) {
                thread.interrupt();
            }
            return true;
        }
        return false;
    }

    protected boolean tryCancel() {
        return true;
    }

    protected void setSubprogress(double offset, double size) {
        this.subprogressOffset = offset;
        this.subprogressSize = size;
    }

    protected void fireTitleChange(String message) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((ProgressListener)listeners[i + 1]).titleChanged(new TitleChangeEvent(this, message));
        }
    }

    protected void fireStatusChange(String message) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((ProgressListener)listeners[i + 1]).statusChanged(new StatusChangeEvent(this, message));
        }
    }

    protected void fireValueChange(double value) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((ProgressListener)listeners[i + 1]).valueChanged(new ValueChangeEvent(this, value));
        }
    }

    protected void fireAdjustedValueChange(double value) {
        this.fireValueChange(value * this.subprogressSize + this.subprogressOffset);
    }

    private void fireComplete() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((ProgressListener)listeners[i + 1]).completed(new EventObject(this));
        }
    }

    public static TaskWorker startWorker(Window frame, Task task) {
        ProgressDialog dialog = new ProgressDialog(frame, task, task.getInitialTitle());
        task.setComponent(dialog);
        task.addProgressListener(dialog);
        TaskWorker thread = new TaskWorker(task);
        thread.start();
        dialog.setVisible(true);
        return thread;
    }

    public static class ExecutionException
    extends Exception {
        private static final long serialVersionUID = 7477571317146886480L;

        public ExecutionException() {
        }

        public ExecutionException(String message) {
            super(message);
        }

        public ExecutionException(String message, Throwable t) {
            super(message, t);
        }
    }
}

